/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.hierarchical.divisive;

import ikor.math.DenseMatrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.DynamicNetwork;
import noesis.algorithms.communities.CommunityDetector;
import noesis.algorithms.traversal.ConnectedComponents;

@Label(value="Divisive")
@Description(value="Divisive")
public abstract class DivisiveCommunityDetector
extends CommunityDetector {
    protected DynamicNetwork dn;

    public DivisiveCommunityDetector(AttributeNetwork network) {
        super(network);
        this.dn = new DynamicNetwork<Integer, Integer>(network);
        this.results = new DenseMatrix(network.nodes(), network.nodes(), -1.0);
    }

    @Override
    public void compute() {
        this.results = new DenseMatrix(this.network.nodes(), this.network.nodes(), 1.0);
        ConnectedComponents cc = new ConnectedComponents(this.dn);
        cc.compute();
        int n = cc.components();
        int iter = 0;
        while (this.dn.links() > 0) {
            this.removeBestLink();
            cc = new ConnectedComponents(this.dn);
            cc.compute();
            if (n == cc.components()) continue;
            int i = 0;
            while (i < this.results.columns()) {
                this.results.set(iter, i, cc.component(i));
                ++i;
            }
            ++iter;
            n = cc.components();
        }
    }

    protected abstract void removeBestLink();
}

