/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.hierarchical.divisive;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.algorithms.communities.hierarchical.divisive.DivisiveCommunityDetector;
import noesis.analysis.LinkScore;
import noesis.analysis.structure.LinkBetweenness;

@Label(value="Newman-Girvan")
@Description(value="Newman & Girvan's community detection algorithm")
public class NewmanGirvanCommunityDetector
extends DivisiveCommunityDetector {
    public NewmanGirvanCommunityDetector(AttributeNetwork network) {
        super(network);
    }

    @Override
    protected void removeBestLink() {
        LinkBetweenness task = new LinkBetweenness(this.dn);
        LinkScore linkScore = (LinkScore)task.call();
        int source = -1;
        int destination = -1;
        double bestScore = Double.NEGATIVE_INFINITY;
        int node = 0;
        while (node < this.dn.size()) {
            int link = 0;
            while (link < this.dn.outDegree(node)) {
                double m = linkScore.get(node, this.dn.outLink(node, link));
                if (m > bestScore) {
                    bestScore = m;
                    source = node;
                    destination = this.dn.outLink(node, link);
                }
                ++link;
            }
            ++node;
        }
        this.dn.remove2(source, destination);
    }
}

