/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.hierarchical.divisive;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import java.util.ArrayList;
import java.util.PriorityQueue;
import noesis.AttributeNetwork;
import noesis.Link;
import noesis.algorithms.communities.hierarchical.divisive.DivisiveCommunityDetector;
import noesis.analysis.LinkScore;
import noesis.analysis.structure.communities.LinkClusteringCoefficient;

@Label(value="Radicchi")
@Description(value="Radicchi's community detection algorithm")
public class RadicchiCommunityDetector
extends DivisiveCommunityDetector {
    private Queue queue = new Queue(this.dn.links());

    public RadicchiCommunityDetector(AttributeNetwork network) {
        super(network);
        LinkClusteringCoefficient task = new LinkClusteringCoefficient(this.dn);
        LinkScore measure = (LinkScore)task.call();
        int node = 0;
        while (node < this.dn.size()) {
            int link = 0;
            while (link < this.dn.outDegree(node)) {
                double m = measure.get(node, this.dn.outLink(node, link));
                this.queue.add(new Link<Double>(node, this.dn.outLink(node, link), m));
                ++link;
            }
            ++node;
        }
    }

    private void recompute(Link<Double> linkRemoved) {
        LinkClusteringCoefficient task = new LinkClusteringCoefficient(this.dn);
        ArrayList delete = new ArrayList();
        ArrayList add = new ArrayList();
        this.queue.stream().filter(l -> l.getDestination() == linkRemoved.getSource() || l.getSource() == linkRemoved.getDestination()).map(l -> {
            delete.add(l);
            return l;
        }).filter(l -> l.getDestination() != linkRemoved.getSource() || l.getSource() != linkRemoved.getDestination()).forEach(l -> {
            double newScore = task.compute(l.getSource(), l.getDestination());
            add.add(new Link<Double>(l.getSource(), l.getDestination(), newScore));
        });
        this.queue.removeAll(delete);
        this.queue.addAll(add);
    }

    @Override
    protected void removeBestLink() {
        Link l = (Link)this.queue.poll();
        this.dn.remove2(l.getSource(), l.getDestination());
        this.recompute(l);
    }

    private class Queue
    extends PriorityQueue<Link<Double>> {
        public Queue(int size) {
            super(size, (l1, l2) -> Double.compare((Double)l1.getContent(), (Double)l2.getContent()));
        }
    }
}

