/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.modularity;

import ikor.math.DenseVector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import java.util.ArrayList;
import java.util.Random;
import noesis.AttributeNetwork;
import noesis.Link;
import noesis.algorithms.communities.modularity.ModularityCommunityDetector;
import noesis.algorithms.communities.partitioning.KMeansCommunityDetector;

@Label(value="FastGreedy")
@Description(value="Fast greedy community detection algorithm")
public class FastGreedyCommunityDetector
extends ModularityCommunityDetector {
    double actualModularity;

    public FastGreedyCommunityDetector(AttributeNetwork network) {
        super(network);
    }

    private Link<Double> getGoodLink() {
        Link<Double> link = null;
        Random r = new Random();
        ArrayList remainingLinks = new ArrayList(this.links);
        while (remainingLinks.size() > 0 && link == null) {
            int i = r.nextInt(remainingLinks.size());
            int source = ((Link)remainingLinks.get(i)).getSource();
            int destination = ((Link)remainingLinks.get(i)).getDestination();
            this.dn.add(source, destination);
            double modu = this.computeModularity();
            if (modu > this.actualModularity) {
                link = new Link<Double>(source, destination, modu);
                this.links.set(i, link);
            }
            this.dn.remove(source, destination);
            remainingLinks.remove(i);
        }
        return link;
    }

    @Override
    protected boolean improveModularity() {
        Link<Double> link;
        boolean ok = false;
        if (this.dn.links() > 0 && (link = this.getGoodLink()) != null) {
            ok = true;
            this.dn.add(link.getSource(), link.getDestination());
            this.actualModularity = link.getContent();
            this.links.remove(link);
        }
        return ok;
    }

    @Override
    protected void preprocess() {
        int cliques = (int)((double)this.network.nodes() * 0.5);
        KMeansCommunityDetector k = new KMeansCommunityDetector(this.network, cliques);
        k.compute();
        DenseVector cl = new DenseVector(k.getResults().getRow(0));
        ArrayList<Integer> dealed = new ArrayList<Integer>();
        this.links = new ArrayList();
        int node = 0;
        while (node < this.dn.size()) {
            int[] _links = this.dn.outLinks(node);
            if (_links != null) {
                int link = 0;
                while (link < _links.length) {
                    if (dealed.contains(node) || cl.get(node) != cl.get(_links[link])) {
                        this.links.add(new Link<Double>(node, _links[link], 0.0));
                        this.dn.remove(node, _links[link]);
                    } else {
                        dealed.add(node);
                    }
                    ++link;
                }
            }
            ++node;
        }
        this.actualModularity = this.computeModularity();
    }
}

