/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.modularity;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import java.util.ArrayList;
import noesis.AttributeNetwork;
import noesis.DynamicNetwork;
import noesis.Link;
import noesis.Network;
import noesis.algorithms.communities.CommunityDetector;
import noesis.algorithms.traversal.ConnectedComponents;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.communities.ModularityCoefficient;

@Label(value="Modularity Community Detector")
@Description(value="Modularity Community Detector")
public abstract class ModularityCommunityDetector
extends CommunityDetector {
    protected ArrayList<Link<Double>> links;
    protected DynamicNetwork dn;

    public ModularityCommunityDetector(AttributeNetwork network) {
        super(network);
        this.dn = new DynamicNetwork<Integer, Integer>(network);
    }

    protected double computeModularity() {
        ConnectedComponents cc = new ConnectedComponents(this.dn);
        cc.compute();
        NodeScore dv = new NodeScore("cluster assignment", (Network)this.network);
        int i = 0;
        while (i < this.results.columns()) {
            dv.set(i, cc.component(i));
            ++i;
        }
        ModularityCoefficient md = new ModularityCoefficient(this.network, dv);
        return md.overallValue();
    }

    @Override
    public void compute() {
        this.preprocess();
        while (this.improveModularity()) {
        }
        ConnectedComponents cc = new ConnectedComponents(this.dn);
        cc.compute();
        int i = 0;
        while (i < this.results.columns()) {
            this.results.set(0, i, cc.component(i));
            ++i;
        }
    }

    protected abstract boolean improveModularity();

    protected abstract void preprocess();
}

