/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.modularity;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;
import noesis.AttributeNetwork;
import noesis.Link;
import noesis.algorithms.communities.modularity.ModularityCommunityDetector;

@Label(value="MultiStepGreedy")
@Description(value="Multi-step greedy community detection algorithm")
public class MultiStepGreedyCommunityDetector
extends ModularityCommunityDetector {
    private QMatrix qm;
    private ArrayList<Integer> nodesTouch = new ArrayList();

    @Override
    protected void preprocess() {
        this.links = new ArrayList();
        int node = 0;
        while (node < this.dn.size()) {
            int[] _links = this.dn.outLinks(node);
            if (_links != null) {
                int link = 0;
                while (link < _links.length) {
                    this.links.add(new Link<Double>(node, _links[link], 0.0));
                    this.dn.remove(node, _links[link]);
                    ++link;
                }
            }
            ++node;
        }
        this.qm = new QMatrix(this.links.size());
    }

    public MultiStepGreedyCommunityDetector(AttributeNetwork network) {
        super(network);
    }

    private void recalculateQMatrix() {
        this.qm.clear();
        double modularity = this.computeModularity();
        int i = 0;
        while (i < this.links.size()) {
            int source = ((Link)this.links.get(i)).getSource();
            int destination = ((Link)this.links.get(i)).getDestination();
            this.dn.add(source, destination);
            double m = this.computeModularity() - modularity;
            if (m > 0.0) {
                this.qm.add(new Link<Double>(source, destination, m));
            }
            this.dn.remove(source, destination);
            ++i;
        }
    }

    private void addLinkThatImproves(Link link) {
        int s = link.getSource();
        int d = link.getDestination();
        if (!this.nodesTouch.contains(s) && !this.nodesTouch.contains(d)) {
            this.dn.add(s, d);
            this.links.remove(link);
            this.nodesTouch.add(s);
            this.nodesTouch.add(d);
        }
    }

    @Override
    protected boolean improveModularity() {
        boolean ok = false;
        this.recalculateQMatrix();
        this.nodesTouch.clear();
        Iterator it = this.qm.iterator();
        boolean salir = false;
        while (it.hasNext() && !salir) {
            Link l = (Link)it.next();
            if ((Double)l.getContent() > 0.0) {
                ok = true;
                this.addLinkThatImproves(l);
                continue;
            }
            salir = true;
        }
        return ok;
    }

    private class QMatrix
    extends PriorityQueue<Link<Double>> {
        public QMatrix(int size) {
            super(size, (p1, p2) -> {
                Double a = (Double)p1.getContent();
                Double b = (Double)p2.getContent();
                int res = Double.compare(b, a);
                if (res == 0 && (res = Integer.compare(p1.getSource(), p2.getSource())) == 0) {
                    res = Integer.compare(p1.getDestination(), p2.getDestination());
                }
                return res;
            });
        }
    }
}

