/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.overlapping;

import ikor.collection.DynamicPriorityQueue;
import ikor.collection.DynamicSet;
import ikor.collection.util.Pair;
import ikor.math.DenseMatrix;
import ikor.math.DenseVector;
import ikor.math.Matrix;
import ikor.math.Vector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import java.util.Comparator;
import noesis.AttributeNetwork;
import noesis.algorithms.communities.CommunityDetector;

@Label(value="BigClam")
@Description(value="BigClam community detection algorithm")
public class BigClamCommunityDetector
extends CommunityDetector {
    public static final int DEFAULT_MAX_ITERATIONS = 10000;
    public static final double INITIAL_STEP_SIZE = 1.0;
    public static final double DEFAULT_STOP_RATIO = 0.01;
    public static final int DEFAULT_BLS_ITERATIONS = 100;
    public static final double ALPHA = 0.15;
    public static final double BETA = 0.5;
    private boolean hasConverged;
    private int maxIterations;
    private double initialStepSize;
    private double defaultStopRatio;
    private double defaultBLSIterations;
    private double alpha;
    private double beta;
    private int[][] undirectedNeighbors;

    public BigClamCommunityDetector(AttributeNetwork network) {
        this(network, 10000, 1.0, 0.01, 100.0, 0.15, 0.5);
    }

    public BigClamCommunityDetector(AttributeNetwork network, int maxIterations, double initialStepSize, double defaultStopRatio, double defaultBLSIterations, double alpha, double beta) {
        super(network);
        this.maxIterations = maxIterations;
        this.initialStepSize = initialStepSize;
        this.defaultStopRatio = defaultStopRatio;
        this.defaultBLSIterations = defaultBLSIterations;
        this.alpha = alpha;
        this.beta = beta;
    }

    @Override
    public void compute() {
        this.hasConverged = false;
        if (this.network.nodes() < 2) {
            if (this.network.nodes() == 1) {
                this.results.setRow(0, new double[]{1.0});
            }
        } else {
            this.initUndirectedNeighbors();
            int[] communitySeeds = this.computeCommunitySeeds();
            Matrix strengths = this.initStrengths(communitySeeds);
            int iteration = 0;
            while (iteration < this.maxIterations && !this.hasConverged) {
                this.updateStrengths(strengths);
                ++iteration;
            }
            Vector nodeCluster = this.getClusterAssignment(strengths);
            this.results.setRow(0, nodeCluster);
        }
    }

    public void initUndirectedNeighbors() {
        this.undirectedNeighbors = new int[this.network.nodes()][];
        DynamicSet<Integer> neighbors = new DynamicSet<Integer>();
        int node = 0;
        while (node < this.network.nodes()) {
            int[] outNeighbors;
            int n;
            Object object;
            int[] inNeighbors = this.network.inLinks(node);
            if (inNeighbors != null) {
                object = inNeighbors;
                n = inNeighbors.length;
                int n2 = 0;
                while (n2 < n) {
                    int in = object[n2];
                    neighbors.add(in);
                    ++n2;
                }
            }
            if ((outNeighbors = this.network.outLinks(node)) != null) {
                int[] nArray = outNeighbors;
                int n3 = outNeighbors.length;
                n = 0;
                while (n < n3) {
                    int out = nArray[n];
                    neighbors.add(out);
                    ++n;
                }
            }
            this.undirectedNeighbors[node] = new int[neighbors.size()];
            int i = 0;
            object = neighbors.iterator();
            while (object.hasNext()) {
                int neighbor;
                this.undirectedNeighbors[node][i] = neighbor = ((Integer)object.next()).intValue();
                ++i;
            }
            neighbors.clear();
            ++node;
        }
    }

    private void updateStrengths(Matrix F) {
        Vector sum = new DenseVector(F.columns());
        int cluster = 0;
        while (cluster < F.columns()) {
            ((Vector)sum).set(cluster, F.getColumn(cluster).sum());
            ++cluster;
        }
        double currentLikelihood = 0.0;
        int row = 0;
        while (row < F.rows()) {
            currentLikelihood += this.computeRowLikelihood(F, row, sum, null);
            ++row;
        }
        DenseVector newFRow = new DenseVector(F.columns());
        double nextLikelihood = 0.0;
        int row2 = 0;
        while (row2 < F.rows()) {
            Vector gradient = this.computeGradient(F, row2, sum);
            double stepSize = this.initialStepSize;
            double initialL = this.computeRowLikelihood(F, row2, sum, null);
            double nextL = 0.0;
            int localIterations = 0;
            while ((double)localIterations < this.defaultBLSIterations) {
                double estimated;
                nextL = this.computeRowLikelihood(F, row2, sum, gradient.multiply(stepSize));
                if (!(nextL < (estimated = initialL + this.alpha * stepSize * gradient.dotProduct(gradient))) && Double.isFinite(nextL) && Double.isFinite(estimated)) break;
                stepSize *= this.beta;
                if ((double)localIterations == this.defaultBLSIterations - 1.0) {
                    stepSize = 0.0;
                }
                ++localIterations;
            }
            int column = 0;
            while (column < F.columns()) {
                double oldF = F.get(row2, column);
                double gradientValue = gradient.get(column);
                double newF = oldF + stepSize * gradientValue;
                newF = Math.max(Math.min(newF, 1.0), 0.0);
                ((Vector)newFRow).set(column, newF);
                ++column;
            }
            sum = sum.add(newFRow).subtract(F.getRow(row2));
            F.setRow(row2, newFRow);
            double rowLikelihood = this.computeRowLikelihood(F, row2, sum, null);
            nextLikelihood += rowLikelihood;
            ++row2;
        }
        if (currentLikelihood == 0.0 || Math.abs(nextLikelihood - currentLikelihood) / Math.abs(currentLikelihood) < this.defaultStopRatio) {
            this.hasConverged = true;
        }
        currentLikelihood = nextLikelihood;
    }

    private double computeRowLikelihood(Matrix F, int node, Vector sum, Vector offset) {
        double likelihood = 0.0;
        Vector Fu = F.getRow(node);
        if (offset != null) {
            Fu = Fu.add(offset);
            int i = 0;
            while (i < Fu.size()) {
                Fu.set(i, Math.max(Math.min(Fu.get(i), 1.0), 0.0));
                ++i;
            }
        }
        int[] nArray = this.undirectedNeighbors[node];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int neighbor = nArray[n2];
            likelihood += Math.log(1.0 - Math.exp(-Fu.dotProduct(F.getRow(neighbor))));
            ++n2;
        }
        Vector term = new DenseVector(F.columns());
        term = term.add(Fu);
        term = term.subtract(sum);
        int[] nArray2 = this.undirectedNeighbors[node];
        int n3 = nArray2.length;
        n = 0;
        while (n < n3) {
            int neighbor = nArray2[n];
            term = term.add(F.getRow(neighbor));
            ++n;
        }
        return likelihood += Fu.dotProduct(term);
    }

    private Vector computeGradient(Matrix F, int node, Vector sum) {
        Vector gradient = new DenseVector(F.columns());
        int[] nArray = this.undirectedNeighbors[node];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int neighbor = nArray[n2];
            double np = Math.exp(-F.getRow(node).dotProduct(F.getRow(neighbor)));
            gradient = gradient.add(F.getRow(neighbor).multiply(np / (1.0 - np)));
            gradient = gradient.add(F.getRow(neighbor));
            ++n2;
        }
        gradient = gradient.add(F.getRow(node));
        gradient = gradient.subtract(sum);
        return gradient;
    }

    private double nodeConductance(int nodeIndex) {
        if (this.undirectedNeighbors[nodeIndex].length == 0) {
            return 0.0;
        }
        DynamicSet<Integer> neighbors = new DynamicSet<Integer>();
        neighbors.add(nodeIndex);
        int[] nArray = this.undirectedNeighbors[nodeIndex];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int neighbor = nArray[n2];
            neighbors.add(neighbor);
            ++n2;
        }
        double neighborsDegree = 0.0;
        double nonNeighborsDegree = 0.0;
        int node = 0;
        while (node < this.network.nodes()) {
            if (neighbors.contains(node)) {
                neighborsDegree += (double)this.undirectedNeighbors[node].length;
            } else {
                nonNeighborsDegree += (double)this.undirectedNeighbors[node].length;
            }
            ++node;
        }
        double numerator = 0.0;
        int[] nArray2 = this.undirectedNeighbors[nodeIndex];
        int n3 = nArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            int neighbor = nArray2[n4];
            int[] nArray3 = this.undirectedNeighbors[neighbor];
            int n5 = nArray3.length;
            int n6 = 0;
            while (n6 < n5) {
                int neighbor2 = nArray3[n6];
                if (!neighbors.contains(neighbor2)) {
                    numerator += 1.0;
                }
                ++n6;
            }
            ++n4;
        }
        return numerator / Math.min(neighborsDegree, nonNeighborsDegree);
    }

    private int[] computeCommunitySeeds() {
        double[] conductance = new double[this.network.nodes()];
        int nodeIndex = 0;
        while (nodeIndex < this.network.nodes()) {
            conductance[nodeIndex] = this.nodeConductance(nodeIndex);
            ++nodeIndex;
        }
        DynamicPriorityQueue<Pair<Integer, Double>> conductanceList = new DynamicPriorityQueue<Pair<Integer, Double>>(new Comparator<Pair<Integer, Double>>(){

            @Override
            public int compare(Pair<Integer, Double> o1, Pair<Integer, Double> o2) {
                return o1.second().compareTo(o2.second());
            }
        });
        int node = 0;
        while (node < this.network.nodes()) {
            if (this.undirectedNeighbors[node].length > 0) {
                boolean isSeed = true;
                double avgConductance = 0.0;
                int[] nArray = this.undirectedNeighbors[node];
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int neigh = nArray[n2];
                    avgConductance += conductance[neigh];
                    if (conductance[node] >= conductance[neigh]) {
                        isSeed = false;
                    }
                    ++n2;
                }
                avgConductance /= (double)this.undirectedNeighbors[node].length;
                if (isSeed) {
                    conductanceList.add(new Pair<Integer, Double>(node, avgConductance - conductance[node]));
                }
            }
            ++node;
        }
        int[] seeds = new int[conductanceList.size()];
        int seed = 0;
        while (seed < seeds.length) {
            seeds[seed] = (Integer)((Pair)conductanceList.get()).first();
            ++seed;
        }
        return seeds;
    }

    private Matrix initStrengths(int[] communitySeeds) {
        int[] actualCommunitySeeds = null;
        if (communitySeeds.length < 2) {
            int[] nArray = new int[2];
            nArray[1] = this.network.nodes() - 1;
            actualCommunitySeeds = nArray;
        } else {
            actualCommunitySeeds = communitySeeds;
        }
        DenseMatrix strengths = new DenseMatrix(this.network.nodes(), actualCommunitySeeds.length);
        int cluster = 0;
        while (cluster < actualCommunitySeeds.length) {
            ((Matrix)strengths).set(actualCommunitySeeds[cluster], cluster, 1.0);
            int[] nArray = this.undirectedNeighbors[actualCommunitySeeds[cluster]];
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int neighbor = nArray[n2];
                ((Matrix)strengths).set(neighbor, cluster, 1.0);
                ++n2;
            }
            int i = 0;
            while (i < ((Matrix)strengths).rows()) {
                int j = 0;
                while (j < ((Matrix)strengths).columns()) {
                    if (((Matrix)strengths).get(i, j) != 1.0) {
                        ((Matrix)strengths).set(i, j, 0.01);
                    }
                    ++j;
                }
                ++i;
            }
            ++cluster;
        }
        return strengths;
    }

    private Vector getClusterAssignment(Matrix F) {
        DenseVector nodeCluster = new DenseVector(this.network.nodes());
        int nodeIndex = 0;
        while (nodeIndex < this.network.nodes()) {
            double strongerScore = -1.7976931348623157E308;
            int strongerIndex = -1;
            int clusterIndex = 0;
            while (clusterIndex < F.columns()) {
                if (strongerScore < F.get(nodeIndex, clusterIndex)) {
                    strongerIndex = clusterIndex;
                    strongerScore = F.get(nodeIndex, clusterIndex);
                }
                ++clusterIndex;
            }
            ((Vector)nodeCluster).set(nodeIndex, strongerIndex);
            ++nodeIndex;
        }
        return nodeCluster;
    }
}

