/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.partitioning;

import ikor.math.DenseMatrix;
import ikor.math.DenseVector;
import ikor.math.random.Random;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.algorithms.communities.partitioning.PartitioningCommunityDetector;
import noesis.algorithms.communities.spectral.SpectralCommunityDetector;
import noesis.algorithms.visualization.FruchtermanReingoldLayout;

@Label(value="KMeans Community Detection")
@Description(value="KMeans Community Detection Algorithm")
public class KMeansCommunityDetector
extends PartitioningCommunityDetector {
    private int K;

    public KMeansCommunityDetector(AttributeNetwork network) {
        super(network);
        this.K = 3;
    }

    public KMeansCommunityDetector(AttributeNetwork network, int K) {
        super(network);
        this.K = K;
    }

    @Override
    public void compute() {
        int i = 0;
        while (i < this.network.nodes()) {
            double x = 0.05 + 0.9 * Random.random();
            double y = 0.05 + 0.9 * Random.random();
            this.network.setNodeAttribute("x", i, String.valueOf(x));
            this.network.setNodeAttribute("y", i, String.valueOf(y));
            ++i;
        }
        FruchtermanReingoldLayout frl = new FruchtermanReingoldLayout();
        frl.layout(this.network, this.network.getNodeAttribute("x"), this.network.getNodeAttribute("y"));
        DenseMatrix F = new DenseMatrix(this.network.nodes(), 2);
        int i2 = 0;
        while (i2 < F.rows()) {
            F.set(i2, 0, (Double)this.network.getNodeAttribute("x").get(i2));
            F.set(i2, 1, (Double)this.network.getNodeAttribute("y").get(i2));
            ++i2;
        }
        DenseVector CL = SpectralCommunityDetector.kMeans(F, this.K, 1.0E10);
        int i3 = 0;
        while (i3 < this.results.columns()) {
            this.results.set(0, i3, CL.get(i3));
            ++i3;
        }
    }
}

