/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.partitioning;

import ikor.collection.CollectionFactory;
import ikor.collection.List;
import ikor.collection.util.Pair;
import ikor.math.DenseVector;
import ikor.math.Matrix;
import ikor.math.Vector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.algorithms.communities.CommunityDetector;
import noesis.algorithms.communities.spectral.SpectralCommunityDetector;

@Label(value="KernighanLin")
@Description(value="Kernighan-Lin graph partitioning algorithm")
public class KernighanLinCommunityDetector
extends CommunityDetector {
    public KernighanLinCommunityDetector(AttributeNetwork network) {
        super(network);
    }

    @Override
    public void compute() {
        int no;
        double gmax;
        List A = CollectionFactory.createList();
        List B = CollectionFactory.createList();
        List AA = CollectionFactory.createList();
        List BB = CollectionFactory.createList();
        int node = 0;
        while (node < this.network.nodes()) {
            if (node % 2 == 0) {
                A.add(node);
                AA.add(node);
            } else {
                B.add(node);
                BB.add(node);
            }
            ++node;
        }
        DenseVector D = new DenseVector(this.network.nodes());
        List L = CollectionFactory.createList();
        int node2 = 0;
        while (node2 < this.network.nodes()) {
            D.set(node2, 0.0);
            L.add(false);
            ++node2;
        }
        Matrix C = SpectralCommunityDetector.adjacencyMatrix(this.network);
        List G = CollectionFactory.createList();
        do {
            int i;
            this.computeD(A, B, L, C, D);
            this.computeD(B, A, L, C, D);
            int locks = 0;
            do {
                int namg = -1;
                int nbmg = -1;
                double mg = Double.NEGATIVE_INFINITY;
                i = 0;
                while (i < A.size()) {
                    int na = (Integer)A.get(i);
                    if (!((Boolean)L.get(na)).booleanValue()) {
                        int j = 0;
                        while (j < B.size()) {
                            double g;
                            int nb = (Integer)B.get(j);
                            if (!((Boolean)L.get(nb)).booleanValue() && (g = D.get(na) + D.get(nb) - 2.0 * C.get(na, nb)) > mg) {
                                mg = g;
                                namg = i;
                                nbmg = j;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                int temp = (Integer)A.get(namg);
                A.set(namg, (Integer)B.get(nbmg));
                B.set(nbmg, temp);
                L.set((Integer)A.get(namg), true);
                L.set((Integer)B.get(nbmg), true);
                locks += 2;
                Pair p = new Pair(B.get(nbmg), A.get(namg));
                G.add(new Pair(p, mg));
                this.updateD(A, (Integer)B.get(nbmg), (Integer)A.get(namg), L, C, D);
                this.updateD(B, (Integer)A.get(namg), (Integer)B.get(nbmg), L, C, D);
            } while (locks < this.network.nodes() - 1);
            int k = 0;
            double g = 0.0;
            gmax = Double.NEGATIVE_INFINITY;
            int i2 = 0;
            while (i2 < G.size()) {
                if ((g += ((Double)((Pair)G.get(i2)).second()).doubleValue()) > gmax) {
                    k = i2 + 1;
                    gmax = g;
                }
                ++i2;
            }
            if (gmax > 0.0) {
                i = 0;
                while (i < k) {
                    Pair p = (Pair)((Pair)G.get(i)).first();
                    int pos1 = AA.index((Integer)p.first());
                    int pos2 = BB.index((Integer)p.second());
                    int temp = (Integer)AA.get(pos1);
                    AA.set(pos1, (Integer)BB.get(pos2));
                    BB.set(pos2, temp);
                    ++i;
                }
                A.clear();
                i = 0;
                while (i < AA.size()) {
                    A.add((Integer)AA.get(i));
                    ++i;
                }
                B.clear();
                i = 0;
                while (i < BB.size()) {
                    B.add((Integer)BB.get(i));
                    ++i;
                }
            }
            i2 = 0;
            while (i2 < L.size()) {
                L.set(i2, false);
                D.set(i2, 0.0);
                ++i2;
            }
            G.clear();
        } while (gmax > 0.0);
        int i = 0;
        while (i < AA.size()) {
            no = (Integer)AA.get(i);
            this.results.set(0, no, 1.0);
            ++i;
        }
        i = 0;
        while (i < BB.size()) {
            no = (Integer)BB.get(i);
            this.results.set(0, no, 2.0);
            ++i;
        }
    }

    private void computeD(List<Integer> IG, List<Integer> EG, List<Boolean> L, Matrix C, Vector D) {
        int i = 0;
        while (i < IG.size()) {
            double ic = 0.0;
            double ec = 0.0;
            int no = (Integer)IG.get(i);
            if (!((Boolean)L.get(no)).booleanValue()) {
                int j = 0;
                while (j < IG.size()) {
                    ic += C.get(no, (Integer)IG.get(j));
                    ++j;
                }
                j = 0;
                while (j < EG.size()) {
                    ec += C.get(no, (Integer)EG.get(j));
                    ++j;
                }
                D.set(no, ec - ic);
            }
            ++i;
        }
    }

    private void updateD(List<Integer> G, int in, int en, List<Boolean> L, Matrix C, Vector D) {
        int i = 0;
        while (i < G.size()) {
            int node = (Integer)G.get(i);
            if (!((Boolean)L.get(node)).booleanValue()) {
                double d = D.get(node);
                D.set(node, d += 2.0 * C.get(node, in) - 2.0 * C.get(node, en));
            }
            ++i;
        }
    }
}

