/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.spectral;

import ikor.math.DenseVector;
import ikor.math.Matrix;
import ikor.math.Vector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.algorithms.communities.spectral.SpectralCommunityDetector;

@Label(value="EIG1")
@Description(value="EIG1 spectral community detection algorithm")
public class EIG1CommunityDetector
extends SpectralCommunityDetector {
    ThresholdType threshold;

    public EIG1CommunityDetector(AttributeNetwork network) {
        super(network);
        this.threshold = ThresholdType.ZERO;
    }

    public EIG1CommunityDetector(AttributeNetwork network, ThresholdType th) {
        super(network);
        this.threshold = th;
    }

    @Override
    public void compute() {
        Matrix L = EIG1CommunityDetector.laplacian(this.network, SpectralCommunityDetector.Normalization.NONE);
        Vector E = EIG1CommunityDetector.FiedlerEigenvector(L);
        int c1 = 0;
        int c2 = 1;
        double th = this.threshold(E, this.threshold);
        Vector CL = EIG1CommunityDetector.partitioning(E, c1, c2, th);
        int i = 0;
        while (i < this.results.columns()) {
            this.results.set(0, i, CL.get(i));
            ++i;
        }
    }

    private static Vector partitioning(Vector E, int cluster1, int cluster2, double th) {
        int size = E.size();
        DenseVector CL = new DenseVector(size);
        int i = 0;
        while (i < size) {
            if (E.get(i) < th) {
                CL.set(i, cluster1);
            } else {
                CL.set(i, cluster2);
            }
            ++i;
        }
        return CL;
    }

    private double threshold(Vector E, ThresholdType th) {
        double value = 0.0;
        switch (th) {
            case AVG: {
                value = E.average();
                break;
            }
            case MEDIAN: {
                DenseVector M = new DenseVector(E);
                EIG1CommunityDetector.QuickSort(M);
                value = ((Vector)M).get(Math.round(((Vector)M).size() / 2));
                break;
            }
            case GAP: {
                DenseVector G = new DenseVector(E);
                EIG1CommunityDetector.QuickSort(G);
                int pos = -1;
                int i = 0;
                while (i < ((Vector)G).size() - 1) {
                    if (Math.abs(((Vector)G).get(i) - ((Vector)G).get(i + 1)) > value) {
                        value = Math.abs(((Vector)G).get(i) - ((Vector)G).get(i + 1));
                        pos = i + 1;
                    }
                    ++i;
                }
                if (pos == -1) break;
                value = ((Vector)G).get(pos);
                break;
            }
            default: {
                value = 0.0;
            }
        }
        return value;
    }

    public static enum ThresholdType {
        ZERO,
        AVG,
        MEDIAN,
        GAP;

    }
}

