/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.spectral;

import ikor.math.DenseVector;
import ikor.math.Matrix;
import ikor.math.Vector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.algorithms.communities.spectral.SpectralCommunityDetector;

@Label(value="KNSC1")
@Description(value="KNSC1 spectral community detection algorithm")
public class NJWCommunityDetector
extends SpectralCommunityDetector {
    private int K;

    public NJWCommunityDetector(AttributeNetwork network) {
        this(network, (int)Math.sqrt(network.size()));
    }

    public NJWCommunityDetector(AttributeNetwork network, int clusters) {
        super(network);
        this.K = clusters > 0 ? clusters : 1;
    }

    @Override
    public void compute() {
        Matrix L = NJWCommunityDetector.laplacian(this.network, SpectralCommunityDetector.Normalization.SYMMETRIC);
        Matrix E = NJWCommunityDetector.eigenvectors(L, this.K);
        int i = 0;
        while (i < E.rows()) {
            double sum = 0.0;
            int j = 0;
            while (j < E.columns()) {
                sum += E.get(i, j) * E.get(i, j);
                ++j;
            }
            sum = Math.sqrt(sum);
            j = 0;
            while (j < E.columns()) {
                E.set(i, j, E.get(i, j) / sum);
                ++j;
            }
            ++i;
        }
        DenseVector CL = NJWCommunityDetector.kMeans(E, this.K, 1.0E10);
        int i2 = 0;
        while (i2 < this.results.columns()) {
            this.results.set(0, i2, ((Vector)CL).get(i2));
            ++i2;
        }
    }
}

