/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.spectral;

import ikor.math.DenseMatrix;
import ikor.math.DenseVector;
import ikor.math.EigenvectorDecomposition;
import ikor.math.Matrix;
import ikor.math.SparseMatrix;
import ikor.math.Vector;
import ikor.math.random.Random;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.algorithms.communities.CommunityDetector;

@Label(value="Spectral Community Detector")
@Description(value="Generic Spectral Community Detection Algorithm")
public abstract class SpectralCommunityDetector
extends CommunityDetector {
    public SpectralCommunityDetector(AttributeNetwork network) {
        super(network);
    }

    public static Matrix adjacencyMatrix(Network net) {
        double value = 1.0;
        int size = net.nodes();
        DenseMatrix W = new DenseMatrix(size, size, 0.0);
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                if (net.contains(i, j)) {
                    W.set(i, j, value);
                }
                ++j;
            }
            ++i;
        }
        return W;
    }

    public static Matrix degreeMatrix(Network net) {
        int size = net.nodes();
        SparseMatrix D = new SparseMatrix(size, size);
        int i = 0;
        while (i < size) {
            ((Matrix)D).set(i, i, net.degree(i));
            ++i;
        }
        return D;
    }

    public static Matrix laplacian(Network net, Normalization norm) {
        Matrix W = SpectralCommunityDetector.adjacencyMatrix(net);
        Matrix D = SpectralCommunityDetector.degreeMatrix(net);
        int size = W.rows();
        DenseMatrix L = (DenseMatrix)D.subtract(W);
        switch (norm) {
            case ASYMMETRIC: {
                L = (DenseMatrix)D.inverse().multiply(L);
                if (L != null) break;
                L = (DenseMatrix)D.subtract(W);
                break;
            }
            case SYMMETRIC: {
                DenseMatrix ID12 = new DenseMatrix(size, size, 0.0);
                int i = 0;
                while (i < size) {
                    ID12.set(i, i, Math.sqrt(D.get(i, i)));
                    ++i;
                }
                if ((ID12 = (DenseMatrix)ID12.inverse()) == null) {
                    L = (DenseMatrix)D.subtract(W);
                    break;
                }
                L = (DenseMatrix)ID12.multiply(L).multiply(ID12);
                break;
            }
        }
        return L;
    }

    public static Matrix eigenvectors(Matrix L, int k) {
        EigenvectorDecomposition ED = new EigenvectorDecomposition(L);
        Matrix E = ED.getEigenvectorMatrix();
        DenseMatrix V = new DenseMatrix(L.rows(), k);
        int i = 0;
        while (i < ((Matrix)V).rows() && i < E.rows()) {
            int j = 0;
            while (j < ((Matrix)V).columns() && j < E.columns()) {
                ((Matrix)V).set(i, j, E.get(i, j));
                ++j;
            }
            ++i;
        }
        return V;
    }

    public static DenseVector eigenvalues(Matrix L) {
        EigenvectorDecomposition ED = new EigenvectorDecomposition(L);
        return (DenseVector)ED.getRealEigenvalues();
    }

    public static Vector FiedlerEigenvector(Matrix L) {
        EigenvectorDecomposition ED = new EigenvectorDecomposition(L);
        DenseMatrix E = (DenseMatrix)ED.getEigenvectorMatrix();
        DenseVector V = new DenseVector(E.rows());
        int i = 0;
        while (i < E.rows()) {
            V.set(i, E.get(i, 1));
            ++i;
        }
        return V;
    }

    public static long estimateClusters(Network net) {
        Matrix L = SpectralCommunityDetector.laplacian(net, Normalization.NONE);
        return SpectralCommunityDetector.estimateClusters(L);
    }

    public static long estimateClusters(Matrix L) {
        long k = 0L;
        DenseVector E = SpectralCommunityDetector.eigenvalues(L);
        double gap = Double.MIN_VALUE;
        int i = 0;
        while (i < ((Vector)E).size() - 1) {
            if (Math.abs(((Vector)E).get(i) - ((Vector)E).get(i + 1)) > gap) {
                gap = Math.abs(((Vector)E).get(i) - ((Vector)E).get(i + 1));
                k = i + 1;
            }
            ++i;
        }
        return k;
    }

    public static double distance(Matrix NA, int element, Matrix CA, int centroid) {
        double dist = 0.0;
        int value = 0;
        while (value < NA.columns() && value < CA.columns()) {
            dist += (CA.get(centroid, value) - NA.get(element, value)) * (CA.get(centroid, value) - NA.get(element, value));
            ++value;
        }
        return Math.sqrt(dist);
    }

    public static DenseVector kMeans(Matrix E, int K, double msse) {
        int elements = E.rows();
        int attrs = E.columns();
        double max = E.max();
        double min = E.min();
        DenseMatrix CE = new DenseMatrix(K, attrs, 0.0);
        DenseMatrix NCE = new DenseMatrix(K, attrs, 0.0);
        int i = 0;
        while (i < CE.rows()) {
            int j = 0;
            while (j < CE.columns()) {
                CE.set(i, j, min + Random.random() * (max - min));
                ++j;
            }
            ++i;
        }
        DenseVector CL = new DenseVector(elements);
        DenseVector NCL = new DenseVector(elements);
        DenseVector NIC = new DenseVector(K);
        Double minSSE = Double.MAX_VALUE;
        Boolean salir = false;
        while (!salir.booleanValue()) {
            int i2 = 0;
            while (i2 < NCE.rows()) {
                int j = 0;
                while (j < NCE.columns()) {
                    NCE.set(i2, j, 0.0);
                    ++j;
                }
                NIC.set(i2, 0.0);
                ++i2;
            }
            int centroideAsigned = -1;
            double SSE = 0.0;
            int element = 0;
            while (element < elements) {
                Double distMin = Double.MAX_VALUE;
                int centroid = 0;
                while (centroid < CE.rows()) {
                    double dist = SpectralCommunityDetector.distance(E, element, CE, centroid);
                    if (dist < distMin) {
                        distMin = dist;
                        NCL.set(element, centroid);
                        centroideAsigned = centroid;
                    }
                    ++centroid;
                }
                int i3 = 0;
                while (i3 < NCE.columns()) {
                    NCE.set(centroideAsigned, i3, NCE.get(centroideAsigned, i3) + E.get(centroideAsigned, i3));
                    ++i3;
                }
                NIC.set(centroideAsigned, NIC.get(centroideAsigned) + 1.0);
                SSE += distMin * distMin;
                ++element;
            }
            int i4 = 0;
            while (i4 < CE.rows()) {
                int j = 0;
                while (j < CE.columns()) {
                    if (NIC.get(i4) != 0.0) {
                        CE.set(i4, j, NCE.get(i4, j) / NIC.get(i4));
                    } else {
                        CE.set(i4, j, min + Random.random() * (max - min));
                    }
                    ++j;
                }
                ++i4;
            }
            if (minSSE - msse > SSE) {
                minSSE = SSE;
                CL = new DenseVector(NCL);
                continue;
            }
            if (minSSE > SSE) {
                CL = new DenseVector(NCL);
            }
            salir = true;
        }
        return CL;
    }

    public static void QuickSort(Vector array) {
        SpectralCommunityDetector.QuickSort(array, 0, array.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    public static void QuickSort(Vector array, int start, int end) {
        block3: {
            i = start;
            k = end;
            if (end - start < 1) break block3;
            pivot = array.get(start);
            ** GOTO lbl14
            {
                ++i;
                do {
                    if (array.get(i) <= pivot && i <= end && k > i) continue block0;
                    while (array.get(k) > pivot && k >= start && k >= i) {
                        --k;
                    }
                    if (k <= i) continue;
                    array.swap(i, k);
lbl14:
                    // 3 sources

                } while (k > i);
            }
            array.swap(start, k);
            SpectralCommunityDetector.QuickSort(array, start, k - 1);
            SpectralCommunityDetector.QuickSort(array, k + 1, end);
        }
    }

    public static enum Normalization {
        NONE,
        SYMMETRIC,
        ASYMMETRIC;

    }
}

