/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.spectral;

import ikor.math.DenseVector;
import ikor.math.Matrix;
import ikor.math.Vector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.algorithms.communities.spectral.SpectralCommunityDetector;

@Label(value="UKMeans")
@Description(value="Spectral k-means community detection algorithm")
public class UKMeansCommunityDetector
extends SpectralCommunityDetector {
    private int K;

    public UKMeansCommunityDetector(AttributeNetwork network) {
        this(network, (int)Math.sqrt(network.size()));
    }

    public UKMeansCommunityDetector(AttributeNetwork network, int clusters) {
        super(network);
        this.K = clusters > 0 ? clusters : 1;
    }

    @Override
    public void compute() {
        Matrix L = UKMeansCommunityDetector.laplacian(this.network, SpectralCommunityDetector.Normalization.NONE);
        Matrix E = UKMeansCommunityDetector.eigenvectors(L, this.K);
        DenseVector CL = UKMeansCommunityDetector.kMeans(E, this.K, 1.0E10);
        int i = 0;
        while (i < this.results.columns()) {
            this.results.set(0, i, ((Vector)CL).get(i));
            ++i;
        }
    }
}

