/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.mst;

import ikor.collection.DynamicPriorityQueue;
import ikor.collection.Evaluator;
import ikor.collection.EvaluatorComparator;
import ikor.collection.PriorityQueue;
import ikor.collection.util.UnionFind;
import noesis.ArrayNetwork;
import noesis.Link;
import noesis.Network;

public class KruskalMinimumSpanningTree<V, E> {
    private Network<V, E> network;
    private Evaluator<E> evaluator;
    private Network<V, E> mst;
    private double weight;

    public KruskalMinimumSpanningTree(Network<V, E> net, Evaluator<E> linkEvaluator) {
        this.network = net;
        this.evaluator = linkEvaluator;
    }

    public void run() {
        this.mst = new ArrayNetwork();
        this.weight = 0.0;
        int i = 0;
        while (i < this.network.size()) {
            this.mst.add(this.network.get(i));
            ++i;
        }
        PriorityQueue<Link<E>> queue = this.createPriorityQueue();
        UnionFind uf = new UnionFind(this.network.size());
        while (queue.size() > 0 && this.mst.links() < this.network.size() - 1) {
            Link<E> link = queue.get();
            if (uf.inSameSet(link.getSource(), link.getDestination())) continue;
            uf.union(link.getSource(), link.getDestination());
            this.mst.add(link.getSource(), link.getDestination(), link.getContent());
            this.weight += this.evaluator.evaluate(link.getContent());
        }
    }

    private PriorityQueue<Link<E>> createPriorityQueue() {
        LinkEvaluator linkEvaluator = new LinkEvaluator(this.evaluator);
        EvaluatorComparator comparator = new EvaluatorComparator(linkEvaluator);
        DynamicPriorityQueue<Link<E>> queue = new DynamicPriorityQueue<Link<E>>(comparator);
        int i = 0;
        while (i < this.network.size()) {
            int[] links = this.network.outLinks(i);
            int j = 0;
            while (j < links.length) {
                if (i < links[j]) {
                    queue.add(new Link<E>(i, links[j], this.network.get(i, links[j])));
                }
                ++j;
            }
            ++i;
        }
        return queue;
    }

    public Network<V, E> MST() {
        return this.mst;
    }

    public double weight() {
        return this.weight;
    }

    class LinkEvaluator
    implements Evaluator<Link<E>> {
        private Evaluator<E> evaluator;

        public LinkEvaluator(Evaluator<E> evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public double evaluate(Link<E> object) {
            return this.evaluator.evaluate(object.getContent());
        }
    }
}

