/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.mst;

import ikor.collection.Evaluator;
import ikor.collection.EvaluatorComparator;
import ikor.collection.IndexedPriorityQueue;
import ikor.collection.Indexer;
import ikor.collection.PriorityQueue;
import noesis.ArrayNetwork;
import noesis.Network;

public class PrimMinimumSpanningTree<V, E> {
    private Network<V, E> network;
    private Evaluator<E> linkEvaluator;
    private double weight;
    private int[] parent;

    public PrimMinimumSpanningTree(Network<V, E> net, Evaluator<E> linkEvaluator) {
        this.network = net;
        this.linkEvaluator = linkEvaluator;
    }

    public void run() {
        int size = this.network.size();
        this.parent = new int[size];
        double[] cost = new double[size];
        boolean[] visited = new boolean[size];
        PriorityQueue<Integer> queue = this.createPriorityQueue(size, cost);
        int i = 0;
        while (i < size) {
            this.parent[i] = -1;
            cost[i] = Double.POSITIVE_INFINITY;
            queue.add(i);
            ++i;
        }
        this.updateCost(queue, cost, 0, 0.0);
        while (queue.size() > 0) {
            int vertex = queue.get();
            visited[vertex] = true;
            int[] links = this.network.outLinks(vertex);
            if (links == null) continue;
            int j = 0;
            while (j < links.length) {
                double linkValue;
                if (!visited[links[j]] && (linkValue = this.linkEvaluator.evaluate(this.network.get(vertex, links[j]))) < cost[links[j]]) {
                    this.parent[links[j]] = vertex;
                    this.updateCost(queue, cost, links[j], linkValue);
                }
                ++j;
            }
        }
        this.weight = 0.0;
        i = 0;
        while (i < this.network.size()) {
            this.weight += cost[i];
            ++i;
        }
    }

    private void updateCost(PriorityQueue queue, double[] cost, int node, double newCost) {
        queue.remove(node);
        cost[node] = newCost;
        queue.add(node);
    }

    private PriorityQueue<Integer> createPriorityQueue(int size, double[] cost) {
        PrimNodeIndexer nodeIndexer = new PrimNodeIndexer();
        PrimNodeEvaluator nodeEvaluator = new PrimNodeEvaluator(cost);
        EvaluatorComparator<Integer> nodeComparator = new EvaluatorComparator<Integer>(nodeEvaluator);
        IndexedPriorityQueue<Integer> queue = new IndexedPriorityQueue<Integer>(size, nodeComparator, nodeIndexer);
        return queue;
    }

    public Network<V, E> MST() {
        ArrayNetwork<V, E> mst = new ArrayNetwork<V, E>();
        int i = 0;
        while (i < this.network.size()) {
            mst.add(this.network.get(i));
            ++i;
        }
        i = 0;
        while (i < this.network.size()) {
            if (this.parent[i] != -1) {
                E link = this.network.get(this.parent[i], i);
                mst.add(this.parent[i], i, link);
            }
            ++i;
        }
        return mst;
    }

    public int parent(int node) {
        return this.parent[node];
    }

    public double weight() {
        return this.weight;
    }

    class PrimNodeEvaluator
    implements Evaluator<Integer> {
        double[] cost;

        public PrimNodeEvaluator(double[] cost) {
            this.cost = cost;
        }

        @Override
        public double evaluate(Integer object) {
            return this.cost[object];
        }
    }

    class PrimNodeIndexer
    implements Indexer<Integer> {
        PrimNodeIndexer() {
        }

        @Override
        public int index(Integer object) {
            return object;
        }
    }
}

