/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.paths;

import ikor.collection.Evaluator;
import ikor.collection.IndexedPriorityQueue;
import ikor.collection.Indexer;
import ikor.collection.PriorityQueue;
import noesis.Network;
import noesis.algorithms.paths.PathFinder;
import noesis.algorithms.paths.SingleSourcePathFinder;

public class AStarPathFinder<V, E>
extends SingleSourcePathFinder<V, E>
implements PathFinder<V, E> {
    private Evaluator<E> linkEvaluator;
    private Evaluator<V> heuristicEvaluator;
    private double[] g;
    private double[] h;

    public AStarPathFinder(Network<V, E> net, int origin, Evaluator<E> linkEvaluator, Evaluator<V> heuristicEvaluator) {
        super(net, origin);
        this.linkEvaluator = linkEvaluator;
        this.heuristicEvaluator = heuristicEvaluator;
    }

    @Override
    public void run() {
        int size = this.network.size();
        this.predecessor = new int[size];
        this.g = new double[size];
        this.h = new double[size];
        PriorityQueue<Integer> open = this.createPriorityQueue(size);
        boolean[] closed = new boolean[this.network.size()];
        int i = 0;
        while (i < size) {
            this.predecessor[i] = -1;
            closed[i] = false;
            this.g[i] = Double.POSITIVE_INFINITY;
            this.h[i] = Double.POSITIVE_INFINITY;
            ++i;
        }
        this.g[this.origin] = 0.0;
        this.h[this.origin] = this.heuristicEvaluator.evaluate(this.network.get(this.origin));
        open.add(this.origin);
        while (open.size() > 0) {
            int vertex = open.get();
            int degree = this.network.outDegree(vertex);
            closed[vertex] = true;
            int j = 0;
            while (j < degree) {
                double linkValue;
                double nodeValue;
                int target = this.network.outLink(vertex, j);
                if (!closed[target] && (nodeValue = this.g[vertex] + (linkValue = this.linkEvaluator.evaluate(this.network.get(vertex, target)))) < this.g[target]) {
                    this.g[target] = nodeValue;
                    this.h[target] = this.heuristicEvaluator.evaluate(this.network.get(target));
                    this.predecessor[target] = vertex;
                    open.add(target);
                }
                ++j;
            }
        }
    }

    private PriorityQueue<Integer> createPriorityQueue(int size) {
        AStarNodeIndexer nodeIndexer = new AStarNodeIndexer();
        AStarNodeEvaluator nodeEvaluator = new AStarNodeEvaluator(this.g, this.h);
        IndexedPriorityQueue<Integer> queue = new IndexedPriorityQueue<Integer>(size, nodeEvaluator, nodeIndexer);
        return queue;
    }

    public final double[] cost() {
        return this.g;
    }

    public final double cost(int node) {
        return this.g[node];
    }

    private class AStarNodeEvaluator
    implements Evaluator<Integer> {
        double[] g;
        double[] h;

        public AStarNodeEvaluator(double[] g, double[] h) {
            this.g = g;
            this.h = h;
        }

        @Override
        public double evaluate(Integer object) {
            return this.g[object] + this.h[object];
        }
    }

    private class AStarNodeIndexer
    implements Indexer<Integer> {
        private AStarNodeIndexer() {
        }

        @Override
        public int index(Integer object) {
            return object;
        }
    }
}

