/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.paths;

import ikor.parallel.Kernel;
import ikor.parallel.Parallel;
import noesis.LinkEvaluator;
import noesis.Network;
import noesis.algorithms.paths.AllPairsShortestPathFinder;
import noesis.algorithms.paths.BellmanFordShortestPathFinder;

public class AllPairsBellmanFord<V, E>
extends AllPairsShortestPathFinder<V, E> {
    private boolean negativeCycles;

    public AllPairsBellmanFord(Network<V, E> net, LinkEvaluator linkEvaluator) {
        super(net, linkEvaluator);
    }

    @Override
    public boolean negativeCycleDetected() {
        return this.negativeCycles;
    }

    @Override
    public void run() {
        int n = this.network.size();
        BellmanFordKernel kernel = new BellmanFordKernel();
        this.distance = new double[n][];
        this.negativeCycles = false;
        Parallel.map(kernel, 0, n - 1);
    }

    class BellmanFordKernel
    implements Kernel {
        BellmanFordKernel() {
        }

        public Object call(int index) {
            if (!AllPairsBellmanFord.this.negativeCycles) {
                BellmanFordShortestPathFinder finder = new BellmanFordShortestPathFinder(AllPairsBellmanFord.this.network, index, AllPairsBellmanFord.this.linkEvaluator);
                finder.run();
                AllPairsBellmanFord.this.distance[index] = finder.distance();
                if (finder.negativeCycleDetected()) {
                    AllPairsBellmanFord.this.negativeCycles = true;
                }
            }
            return null;
        }
    }
}

