/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.paths;

import noesis.LinkEvaluator;
import noesis.Network;
import noesis.algorithms.paths.AllPairsShortestPathFinder;

public class AllPairsFloydWarshall<V, E>
extends AllPairsShortestPathFinder<V, E> {
    public AllPairsFloydWarshall(Network<V, E> net, LinkEvaluator linkEvaluator) {
        super(net, linkEvaluator);
    }

    @Override
    public boolean negativeCycleDetected() {
        int i = 0;
        while (i < this.network.size()) {
            if (this.distance[i][i] < 0.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void run() {
        int j;
        int n = this.network.size();
        this.distance = new double[n][n];
        double[][] newDistance = new double[n][n];
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                this.distance[i][j] = Double.POSITIVE_INFINITY;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            this.distance[i][i] = 0.0;
            int degree = this.network.outDegree(i);
            j = 0;
            while (j < degree) {
                int target = this.network.outLink(i, j);
                this.distance[i][target] = this.linkEvaluator.evaluate(i, target);
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < n) {
            int i2 = 0;
            while (i2 < n) {
                int j2 = 0;
                while (j2 < n) {
                    newDistance[i2][j2] = this.distance[i2][j2] < this.distance[i2][k] + this.distance[k][j2] ? this.distance[i2][j2] : this.distance[i2][k] + this.distance[k][j2];
                    ++j2;
                }
                ++i2;
            }
            double[][] tmp = this.distance;
            this.distance = newDistance;
            newDistance = tmp;
            ++k;
        }
    }
}

