/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.paths;

import ikor.parallel.Kernel;
import ikor.parallel.Parallel;
import noesis.LinkEvaluator;
import noesis.Network;
import noesis.algorithms.paths.AllPairsShortestPathFinder;
import noesis.algorithms.paths.BellmanFordShortestPathFinder;
import noesis.algorithms.paths.DijkstraShortestPathFinder;
import noesis.network.AugmentedNetwork;

public class AllPairsJohnson<V, E>
extends AllPairsShortestPathFinder<V, E> {
    private boolean negativeCycles = false;
    LinkEvaluator augmentedEvaluator;
    LinkEvaluator dijkstraEvaluator;
    double[] weight;

    public AllPairsJohnson(Network<V, E> net, LinkEvaluator linkEvaluator) {
        super(net, linkEvaluator);
    }

    @Override
    public boolean negativeCycleDetected() {
        return this.negativeCycles;
    }

    @Override
    public void run() {
        int n = this.network.size();
        Network original = this.network();
        AugmentedNetwork augmented = new AugmentedNetwork(original);
        augmented.add(n);
        int i = 0;
        while (i < n) {
            augmented.add(n, i);
            ++i;
        }
        this.augmentedEvaluator = new AugmentedEvaluator(n, this.linkEvaluator);
        BellmanFordShortestPathFinder<Integer, Integer> finder = new BellmanFordShortestPathFinder<Integer, Integer>(augmented, n, this.augmentedEvaluator);
        finder.run();
        this.negativeCycles = finder.negativeCycleDetected();
        if (!this.negativeCycles) {
            this.weight = finder.distance();
            this.dijkstraEvaluator = new DijkstraEvaluator(this.weight, this.linkEvaluator);
            DijkstraKernel kernel = new DijkstraKernel();
            this.distance = new double[n][];
            Parallel.map(kernel, 0, n - 1);
            this.weight = null;
        }
    }

    class AugmentedEvaluator
    implements LinkEvaluator {
        private int n;
        private LinkEvaluator evaluator;

        public AugmentedEvaluator(int n, LinkEvaluator evaluator) {
            this.n = n;
            this.evaluator = evaluator;
        }

        @Override
        public double evaluate(int source, int destination) {
            if (source != this.n) {
                return this.evaluator.evaluate(source, destination);
            }
            return 0.0;
        }
    }

    class DijkstraEvaluator
    implements LinkEvaluator {
        private double[] weight;
        private LinkEvaluator evaluator;

        public DijkstraEvaluator(double[] weight, LinkEvaluator evaluator) {
            this.weight = weight;
            this.evaluator = evaluator;
        }

        @Override
        public double evaluate(int source, int destination) {
            return this.evaluator.evaluate(source, destination) + this.weight[source] - this.weight[destination];
        }
    }

    class DijkstraKernel
    implements Kernel {
        DijkstraKernel() {
        }

        public Object call(int index) {
            DijkstraShortestPathFinder finder = new DijkstraShortestPathFinder(AllPairsJohnson.this.network, index, AllPairsJohnson.this.dijkstraEvaluator);
            finder.run();
            AllPairsJohnson.this.distance[index] = finder.distance();
            int n = 0;
            while (n < AllPairsJohnson.this.network.size()) {
                double[] dArray = AllPairsJohnson.this.distance[index];
                int n2 = n;
                dArray[n2] = dArray[n2] + (AllPairsJohnson.this.weight[n] - AllPairsJohnson.this.weight[index]);
                ++n;
            }
            return null;
        }
    }
}

