/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.paths;

import noesis.LinkEvaluator;
import noesis.Network;
import noesis.algorithms.paths.PathFinder;
import noesis.algorithms.paths.SingleSourceShortestPathFinder;

public class BellmanFordShortestPathFinder<V, E>
extends SingleSourceShortestPathFinder<V, E>
implements PathFinder<V, E> {
    private boolean negativeCycles;

    public BellmanFordShortestPathFinder(Network<V, E> net, int origin, LinkEvaluator linkEvaluator) {
        super(net, origin, linkEvaluator);
    }

    @Override
    public void run() {
        int size = this.network.size();
        this.predecessor = new int[size];
        this.distance = new double[size];
        double[] newDistance = new double[size];
        int i = 0;
        while (i < size) {
            this.predecessor[i] = -1;
            this.distance[i] = Double.POSITIVE_INFINITY;
            ++i;
        }
        this.distance[this.origin] = 0.0;
        boolean changes = true;
        int iterations = 1;
        while (iterations <= size && changes) {
            changes = false;
            int v = 0;
            while (v < size) {
                newDistance[v] = this.distance[v];
                int degree = this.network.inDegree(v);
                int j = 0;
                while (j < degree) {
                    double linkValue;
                    int w = this.network.inLink(v, j);
                    if (newDistance[v] > this.distance[w] + (linkValue = this.linkEvaluator.evaluate(w, v))) {
                        this.predecessor[v] = w;
                        newDistance[v] = this.distance[w] + linkValue;
                        changes = true;
                    }
                    ++j;
                }
                ++v;
            }
            double[] tmp = this.distance;
            this.distance = newDistance;
            newDistance = tmp;
            ++iterations;
        }
        this.negativeCycles = iterations > size && changes;
    }

    public boolean negativeCycleDetected() {
        return this.negativeCycles;
    }
}

