/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.paths;

import noesis.Network;
import noesis.algorithms.LinkVisitor;
import noesis.algorithms.paths.PathFinder;
import noesis.algorithms.paths.SingleSourcePathFinder;
import noesis.algorithms.traversal.NetworkBFS;

public class BreadthFirstPathFinder<V, E>
extends SingleSourcePathFinder<V, E>
implements PathFinder<V, E> {
    public BreadthFirstPathFinder(Network<V, E> net, int origin) {
        super(net, origin);
    }

    @Override
    public void run() {
        this.predecessor = new int[this.network.size()];
        int i = 0;
        while (i < this.predecessor.length) {
            this.predecessor[i] = -1;
            ++i;
        }
        NetworkBFS bfs = new NetworkBFS(this.network);
        bfs.setLinkVisitor(new BFSVisitor(this.predecessor));
        bfs.traverse(this.origin);
    }

    class BFSVisitor
    extends LinkVisitor {
        private int[] predecessor;

        public BFSVisitor(int[] predecessor) {
            this.predecessor = predecessor;
        }

        @Override
        public void visit(int source, int destination) {
            if (this.predecessor[destination] == -1) {
                this.predecessor[destination] = source;
            }
        }
    }
}

