/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.paths;

import noesis.Network;
import noesis.algorithms.LinkVisitor;
import noesis.algorithms.paths.PathFinder;
import noesis.algorithms.paths.SingleSourcePathFinder;
import noesis.algorithms.traversal.NetworkDFS;

public class DepthFirstPathFinder<V, E>
extends SingleSourcePathFinder<V, E>
implements PathFinder<V, E> {
    public DepthFirstPathFinder(Network<V, E> net, int origin) {
        super(net, origin);
    }

    @Override
    public void run() {
        this.predecessor = new int[this.network.size()];
        int i = 0;
        while (i < this.predecessor.length) {
            this.predecessor[i] = -1;
            ++i;
        }
        NetworkDFS dfs = new NetworkDFS(this.network);
        dfs.setLinkVisitor(new DFSVisitor(this.predecessor));
        dfs.traverse(this.origin);
    }

    class DFSVisitor
    extends LinkVisitor {
        private int[] predecessor;

        public DFSVisitor(int[] predecessor) {
            this.predecessor = predecessor;
        }

        @Override
        public void visit(int source, int destination) {
            if (this.predecessor[destination] == -1) {
                this.predecessor[destination] = source;
            }
        }
    }
}

