/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.paths;

import ikor.collection.Evaluator;
import ikor.collection.IndexedPriorityQueue;
import ikor.collection.Indexer;
import ikor.collection.PriorityQueue;
import noesis.LinkEvaluator;
import noesis.Network;
import noesis.algorithms.paths.PathFinder;
import noesis.algorithms.paths.SingleSourceShortestPathFinder;

public class DijkstraShortestPathFinder<V, E>
extends SingleSourceShortestPathFinder<V, E>
implements PathFinder<V, E> {
    public DijkstraShortestPathFinder(Network<V, E> net, int origin, LinkEvaluator linkEvaluator) {
        super(net, origin, linkEvaluator);
    }

    @Override
    public void run() {
        int size = this.network.size();
        this.predecessor = new int[size];
        this.distance = new double[size];
        PriorityQueue<Integer> queue = this.createPriorityQueue(size);
        int i = 0;
        while (i < size) {
            this.predecessor[i] = -1;
            this.distance[i] = Double.POSITIVE_INFINITY;
            queue.add(i);
            ++i;
        }
        this.updateDistance(queue, this.origin, 0.0);
        while (queue.size() > 0) {
            int vertex = queue.get();
            int degree = this.network.outDegree(vertex);
            int j = 0;
            while (j < degree) {
                double linkValue;
                int target = this.network.outLink(vertex, j);
                if (this.distance[target] > this.distance[vertex] + (linkValue = this.linkEvaluator.evaluate(vertex, target))) {
                    this.predecessor[target] = vertex;
                    this.updateDistance(queue, target, this.distance[vertex] + linkValue);
                }
                ++j;
            }
        }
    }

    private void updateDistance(PriorityQueue queue, int node, double newDistance) {
        queue.remove(node);
        this.distance[node] = newDistance;
        queue.add(node);
    }

    private PriorityQueue<Integer> createPriorityQueue(int size) {
        DijkstraNodeIndexer nodeIndexer = new DijkstraNodeIndexer();
        DijkstraNodeEvaluator nodeEvaluator = new DijkstraNodeEvaluator(this.distance);
        IndexedPriorityQueue<Integer> queue = new IndexedPriorityQueue<Integer>(size, nodeEvaluator, nodeIndexer);
        return queue;
    }

    private class DijkstraNodeEvaluator
    implements Evaluator<Integer> {
        double[] distance;

        public DijkstraNodeEvaluator(double[] distance) {
            this.distance = distance;
        }

        @Override
        public double evaluate(Integer object) {
            return this.distance[object];
        }
    }

    private class DijkstraNodeIndexer
    implements Indexer<Integer> {
        private DijkstraNodeIndexer() {
        }

        @Override
        public int index(Integer object) {
            return object;
        }
    }
}

