/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.paths;

import noesis.ArrayNetwork;
import noesis.Network;
import noesis.algorithms.paths.PathFinder;

public abstract class SingleSourcePathFinder<V, E>
implements PathFinder<V, E> {
    protected Network<V, E> network;
    protected int origin;
    protected int[] predecessor;

    public SingleSourcePathFinder(Network<V, E> net, int origin) {
        this.network = net;
        this.origin = origin;
    }

    @Override
    public final Network<V, E> network() {
        return this.network;
    }

    public final Network<V, E> paths() {
        ArrayNetwork<V, E> paths = new ArrayNetwork<V, E>();
        int i = 0;
        while (i < this.network.size()) {
            ((Network)paths).add(this.network.get(i));
            ++i;
        }
        i = 0;
        while (i < this.network.size()) {
            if (this.predecessor[i] != -1) {
                E link = this.network.get(this.predecessor[i], i);
                paths.add((V)this.predecessor[i], (V)i, link);
            }
            ++i;
        }
        return paths;
    }

    public int[] pathTo(int destination) {
        int[] path = null;
        int length = this.pathLengthTo(destination) + 1;
        if (length > 0) {
            path = new int[length];
            int position = length - 1;
            path[position] = destination;
            while (path[position] != this.origin) {
                path[--position] = this.predecessor[path[position + 1]];
            }
        }
        return path;
    }

    public final int pathLengthTo(int destination) {
        int length = 0;
        int node = destination;
        while (node != this.origin && this.predecessor[node] != -1) {
            ++length;
            node = this.predecessor[node];
        }
        if (node == this.origin) {
            return length;
        }
        return -1;
    }

    public final int predecessor(int node) {
        return this.predecessor[node];
    }
}

