/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.traversal;

import noesis.Network;
import noesis.algorithms.NodeVisitor;
import noesis.algorithms.traversal.NetworkDFS;

public class ConnectedComponents {
    private Network network;
    private int[] index;
    private int[] sizes;
    private int components;

    public ConnectedComponents(Network network) {
        this.network = network;
        this.index = new int[network.size()];
        this.components = 0;
    }

    public final Network getNetwork() {
        return this.network;
    }

    public final int components() {
        return this.components;
    }

    public final int component(int node) {
        return this.index[node];
    }

    public final int componentSize(int node) {
        if (this.sizes == null) {
            this.sizes = this.componentSizes();
        }
        return this.sizes[this.component(node) - 1];
    }

    public final int[] componentIndex() {
        return this.index;
    }

    public final int[] componentSizes() {
        this.sizes = new int[this.components];
        int i = 0;
        while (i < this.network.size()) {
            int n = this.index[i] - 1;
            this.sizes[n] = this.sizes[n] + 1;
            ++i;
        }
        return this.sizes;
    }

    public final void compute() {
        NetworkDFS dfs = new NetworkDFS(this.network);
        dfs.setNodeVisitor(new ComponentVisitor(this));
        int i = 0;
        while (i < this.network.size()) {
            if (this.index[i] == 0) {
                ++this.components;
                dfs.traverse(i);
            }
            ++i;
        }
    }

    private class ComponentVisitor
    extends NodeVisitor {
        private ConnectedComponents cc;

        public ComponentVisitor(ConnectedComponents cc) {
            this.cc = cc;
        }

        @Override
        public void visit(int node) {
            ((ConnectedComponents)this.cc).index[node] = this.cc.components;
        }
    }
}

