/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.traversal;

import ikor.collection.Queue;
import ikor.collection.Visitor;
import noesis.Network;
import noesis.algorithms.traversal.NetworkTraversal;

public class NetworkBFS<V, E>
extends NetworkTraversal<V, E> {
    public NetworkBFS(Network<V, E> graph) {
        super(graph);
    }

    public NetworkBFS(Network<V, E> graph, Visitor<V> nodeVisitor, Visitor<E> linkVisitor) {
        super(graph, nodeVisitor, linkVisitor);
    }

    @Override
    public void traverse(int start) {
        Queue<Integer> queue = new Queue<Integer>();
        queue.enqueue(start);
        while (queue.size() > 0) {
            int current = (Integer)queue.dequeue();
            this.state[current] = NetworkTraversal.State.DISCOVERED;
            this.visitNode(current);
            int degree = this.network.outDegree(current);
            int i = 0;
            while (i < degree) {
                int target = this.network.outLink(current, i);
                this.visitLink(current, target);
                if (this.state[target] == NetworkTraversal.State.UNDISCOVERED) {
                    queue.enqueue(target);
                    this.state[target] = NetworkTraversal.State.DISCOVERED;
                }
                ++i;
            }
            this.state[current] = NetworkTraversal.State.EXPLORED;
        }
    }
}

