/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.traversal;

import ikor.collection.Visitor;
import noesis.Network;
import noesis.algorithms.NodeVisitor;
import noesis.algorithms.traversal.NetworkTraversal;

public class NetworkDFS<V, E>
extends NetworkTraversal<V, E> {
    private Visitor<V> postContentVisitor;
    private NodeVisitor postVisitor;

    public void setNodePostVisitor(NodeVisitor nodeVisitor) {
        this.postVisitor = nodeVisitor;
    }

    public void setNodePostVisitor(Visitor<V> visitor) {
        this.postContentVisitor = visitor;
    }

    protected final void postVisitNode(int node) {
        if (this.postVisitor != null) {
            this.postVisitor.visit(node);
        }
        if (this.postContentVisitor != null) {
            Object nodeContent = this.network.get(node);
            this.postContentVisitor.visit(nodeContent);
        }
    }

    public NetworkDFS(Network<V, E> network) {
        super(network);
    }

    public NetworkDFS(Network<V, E> network, Visitor<V> nodeVisitor) {
        super(network, nodeVisitor, null);
    }

    public NetworkDFS(Network<V, E> network, Visitor<V> nodeVisitor, Visitor<E> linkVisitor) {
        super(network, nodeVisitor, linkVisitor);
    }

    @Override
    public void traverse(int current) {
        this.state[current] = NetworkTraversal.State.DISCOVERED;
        this.visitNode(current);
        int degree = this.network.outDegree(current);
        int i = 0;
        while (i < degree) {
            int target = this.network.outLink(current, i);
            this.visitLink(current, target);
            if (this.state[target] == NetworkTraversal.State.UNDISCOVERED) {
                this.traverse(target);
            }
            ++i;
        }
        this.postVisitNode(current);
        this.state[current] = NetworkTraversal.State.EXPLORED;
    }
}

