/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.traversal;

import ikor.collection.Visitor;
import java.util.Arrays;
import noesis.Network;
import noesis.algorithms.LinkVisitor;
import noesis.algorithms.NodeVisitor;

public abstract class NetworkTraversal<V, E> {
    protected Network<V, E> network;
    protected State[] state;
    private Visitor<V> nodeContentVisitor;
    private Visitor<E> linkContentVisitor;
    private NodeVisitor nodeVisitor;
    private LinkVisitor linkVisitor;

    public NetworkTraversal(Network<V, E> network) {
        this(network, null, null);
    }

    public NetworkTraversal(Network<V, E> network, Visitor<V> nodeVisitor) {
        this(network, nodeVisitor, null);
    }

    public NetworkTraversal(Network<V, E> network, Visitor<V> nodeVisitor, Visitor<E> linkVisitor) {
        this.network = network;
        this.state = new State[network.size()];
        Arrays.fill((Object[])this.state, (Object)State.UNDISCOVERED);
        this.nodeContentVisitor = nodeVisitor;
        this.linkContentVisitor = linkVisitor;
    }

    public void setNodeVisitor(NodeVisitor nodeVisitor) {
        this.nodeVisitor = nodeVisitor;
    }

    public void setLinkVisitor(LinkVisitor linkVisitor) {
        this.linkVisitor = linkVisitor;
    }

    public void setNodeVisitor(Visitor<V> visitor) {
        this.nodeContentVisitor = visitor;
    }

    public void setLinkVisitor(Visitor<E> visitor) {
        this.linkContentVisitor = visitor;
    }

    public final void traverse() {
        int i = 0;
        while (i < this.network.size()) {
            if (this.state[i] == State.UNDISCOVERED) {
                this.traverse(i);
            }
            ++i;
        }
    }

    public abstract void traverse(int var1);

    protected final void visitNode(int node) {
        if (this.nodeVisitor != null) {
            this.nodeVisitor.visit(node);
        }
        if (this.nodeContentVisitor != null) {
            V nodeContent = this.network.get(node);
            this.nodeContentVisitor.visit(nodeContent);
        }
    }

    protected final void visitLink(int source, int destination) {
        if (this.linkVisitor != null) {
            this.linkVisitor.visit(source, destination);
        }
        if (this.linkContentVisitor != null) {
            E linkContent = this.network.get(source, destination);
            this.linkContentVisitor.visit(linkContent);
        }
    }

    public State status(int index) {
        return this.state[index];
    }

    public static enum State {
        UNDISCOVERED,
        DISCOVERED,
        EXPLORED;

    }
}

