/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.traversal;

import noesis.BasicNetwork;
import noesis.Network;
import noesis.algorithms.NodeVisitor;
import noesis.algorithms.traversal.NetworkDFS;
import noesis.algorithms.traversal.TopologicalSort;

public class StronglyConnectedComponents {
    private Network network;
    private int[] index;
    private int components;
    private int[] order;
    private int[] sizes;

    public StronglyConnectedComponents(Network network) {
        this.network = network;
        this.index = new int[network.size()];
        this.components = 0;
    }

    public final Network getNetwork() {
        return this.network;
    }

    public final int components() {
        return this.components;
    }

    public final int component(int node) {
        return this.index[node];
    }

    public final int componentSize(int node) {
        if (this.sizes == null) {
            this.sizes = this.componentSizes();
        }
        return this.sizes[this.component(node) - 1];
    }

    public final int[] componentIndex() {
        return this.index;
    }

    public final int[] componentSizes() {
        this.sizes = new int[this.components];
        int i = 0;
        while (i < this.network.size()) {
            int n = this.index[i] - 1;
            this.sizes[n] = this.sizes[n] + 1;
            ++i;
        }
        return this.sizes;
    }

    private Network reverseNetwork(Network net) {
        BasicNetwork reverse = new BasicNetwork();
        int size = net.size();
        ((Network)reverse).setSize(size);
        int i = 0;
        while (i < size) {
            int degree = net.outDegree(i);
            int j = 0;
            while (j < degree) {
                ((Network)reverse).add(net.outLink(i, j), i);
                ++j;
            }
            ++i;
        }
        return reverse;
    }

    public final void compute() {
        Network reverse = this.reverseNetwork(this.network);
        TopologicalSort ts = new TopologicalSort(reverse);
        ts.sort();
        this.order = ts.nodes();
        NetworkDFS dfs = new NetworkDFS(this.network);
        dfs.setNodeVisitor(new StrongComponentVisitor(this));
        int i = 0;
        while (i < this.network.size()) {
            if (this.index[this.order[i]] == 0) {
                ++this.components;
                dfs.traverse(this.order[i]);
            }
            ++i;
        }
    }

    private class StrongComponentVisitor
    extends NodeVisitor {
        private StronglyConnectedComponents scc;

        public StrongComponentVisitor(StronglyConnectedComponents scc) {
            this.scc = scc;
        }

        @Override
        public void visit(int node) {
            ((StronglyConnectedComponents)this.scc).index[node] = this.scc.components;
        }
    }
}

