/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.traversal;

import noesis.Network;
import noesis.algorithms.NodeVisitor;
import noesis.algorithms.traversal.NetworkDFS;

public class TopologicalSort {
    private Network network;
    private int[] index;

    public TopologicalSort(Network network) {
        this.network = network;
        this.index = new int[network.size()];
    }

    public final Network getNetwork() {
        return this.network;
    }

    public final int[] sort() {
        NetworkDFS dfs = new NetworkDFS(this.network);
        dfs.setNodePostVisitor(new TopologicalVisitor(this));
        dfs.traverse();
        return this.index;
    }

    public final int[] nodes() {
        int[] ordered = new int[this.network.size()];
        int i = 0;
        while (i < this.network.size()) {
            ordered[this.index[i]] = i;
            ++i;
        }
        return ordered;
    }

    private class TopologicalVisitor
    extends NodeVisitor {
        private TopologicalSort sort;
        private int current;

        public TopologicalVisitor(TopologicalSort sort) {
            this.sort = sort;
            this.current = TopologicalSort.this.network.size() - 1;
        }

        @Override
        public void visit(int node) {
            ((TopologicalSort)this.sort).index[node] = this.current--;
        }
    }
}

