/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.visualization;

import noesis.algorithms.visualization.IterativeNetworkLayout;

public class FruchtermanReingoldLayout
extends IterativeNetworkLayout {
    public static final int MAX_ITERATIONS = 100;
    public static final double MIN_TEMPERATURE = 0.005;
    public static final double INITIAL_TEMPERATURE = 1.0;
    public static final double COOLING_FACTOR = 0.95;
    double area;
    double k;
    int iteration;
    double temperature;
    double[] dx;
    double[] dy;
    double[] px;
    double[] py;

    @Override
    public void init() {
        this.area = 0.81;
        this.k = Math.sqrt(this.area / (double)this.network.size());
        this.iteration = 0;
        this.temperature = 1.0;
        this.dx = new double[this.network.size()];
        this.dy = new double[this.network.size()];
        this.px = new double[this.network.size()];
        this.py = new double[this.network.size()];
        int i = 0;
        while (i < this.network.size()) {
            this.px[i] = (Double)this.x.get(i) - 0.5;
            this.py[i] = (Double)this.y.get(i) - 0.5;
            ++i;
        }
    }

    @Override
    public boolean stop() {
        return !(this.temperature > 0.005) || this.iteration >= 100;
    }

    @Override
    public void iterate() {
        double force;
        double distance;
        double deltay;
        double deltax;
        int v = 0;
        while (v < this.network.size()) {
            this.dx[v] = 0.0;
            this.dy[v] = 0.0;
            int w = v + 1;
            while (w < this.network.size()) {
                deltax = this.px[v] - this.px[w];
                deltay = this.py[v] - this.py[w];
                if (deltax != 0.0 || deltay != 0.0) {
                    distance = Math.sqrt(deltax * deltax + deltay * deltay);
                    force = this.repulsiveForce(distance);
                    int n = v;
                    this.dx[n] = this.dx[n] + deltax / distance * force;
                    int n2 = v;
                    this.dy[n2] = this.dy[n2] + deltay / distance * force;
                    int n3 = w;
                    this.dx[n3] = this.dx[n3] - deltax / distance * force;
                    int n4 = w;
                    this.dy[n4] = this.dy[n4] - deltay / distance * force;
                }
                ++w;
            }
            ++v;
        }
        v = 0;
        while (v < this.network.size()) {
            int index = 0;
            while (index < this.network.outDegree(v)) {
                int w = this.network.outLink(v, index);
                deltax = this.px[v] - this.px[w];
                deltay = this.py[v] - this.py[w];
                if (deltax != 0.0 || deltay != 0.0) {
                    distance = Math.sqrt(deltax * deltax + deltay * deltay);
                    force = this.attractiveForce(distance);
                    int n = v;
                    this.dx[n] = this.dx[n] - deltax / distance * force;
                    int n5 = v;
                    this.dy[n5] = this.dy[n5] - deltay / distance * force;
                    int n6 = w;
                    this.dx[n6] = this.dx[n6] + deltax / distance * force;
                    int n7 = w;
                    this.dy[n7] = this.dy[n7] + deltay / distance * force;
                }
                ++index;
            }
            ++v;
        }
        double max = 0.0;
        int v2 = 0;
        while (v2 < this.network.size()) {
            double magnitude = Math.sqrt(this.dx[v2] * this.dx[v2] + this.dy[v2] * this.dy[v2]);
            if (magnitude > 0.0) {
                int n = v2;
                this.px[n] = this.px[n] + this.dx[v2] / magnitude * Math.min(Math.abs(this.dx[v2]), this.temperature);
                int n8 = v2;
                this.py[n8] = this.py[n8] + this.dy[v2] / magnitude * Math.min(Math.abs(this.dy[v2]), this.temperature);
                if (this.px[v2] * this.px[v2] + this.py[v2] * this.py[v2] > max) {
                    max = this.px[v2] * this.px[v2] + this.py[v2] * this.py[v2];
                }
            }
            ++v2;
        }
        double r2 = 0.2025;
        if (max > r2) {
            double rescale = Math.sqrt(r2 / max);
            int v3 = 0;
            while (v3 < this.network.size()) {
                int n = v3;
                this.px[n] = this.px[n] * rescale;
                int n9 = v3++;
                this.py[n9] = this.py[n9] * rescale;
            }
        }
        this.temperature = this.cool(this.temperature);
        ++this.iteration;
    }

    @Override
    public void end() {
        this.dx = null;
        this.dy = null;
        double minX = 1.0;
        double maxX = -1.0;
        double minY = 1.0;
        double maxY = -1.0;
        int i = 0;
        while (i < this.network.size()) {
            if (this.px[i] < minX) {
                minX = this.px[i];
            }
            if (this.px[i] > maxX) {
                maxX = this.px[i];
            }
            if (this.py[i] < minY) {
                minY = this.py[i];
            }
            if (this.py[i] > maxY) {
                maxY = this.py[i];
            }
            ++i;
        }
        double scaleX = maxX > minX ? 0.9 / (maxX - minX) : 1.0;
        double scaleY = maxY > minY ? 0.9 / (maxY - minY) : 1.0;
        int i2 = 0;
        while (i2 < this.network.size()) {
            this.x.set(i2, 0.05 + scaleX * (this.px[i2] - minX));
            this.y.set(i2, 0.05 + scaleY * (this.py[i2] - minY));
            ++i2;
        }
        this.px = null;
        this.py = null;
    }

    private double cool(double t) {
        return t * 0.95;
    }

    private double attractiveForce(double x) {
        return x * x / this.k;
    }

    private double repulsiveForce(double x) {
        return this.k * this.k / x;
    }
}

