/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.visualization;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.collection.DynamicList;
import ikor.collection.DynamicSet;
import ikor.collection.Set;
import java.util.Iterator;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.algorithms.visualization.NetworkLayout;
import noesis.network.FilteredNetwork;
import noesis.network.filter.LinkFilter;

public class HierarchicalLayout
extends NetworkLayout {
    private Network acyclicNetwork;
    private Dictionary<Integer, Integer>[] layerAssignment;

    @Override
    public void layout(AttributeNetwork network, Attribute<Double> x, Attribute<Double> y) {
        this.acyclicNetwork = this.greedyCycleRemoval(network);
        this.layerAssignment = this.layerAssignmentByLongestPath(this.acyclicNetwork);
        if (this.layerAssignment.length > 1) {
            this.reduceCrossings(network);
        }
        double[] px = new double[network.nodes()];
        double[] py = new double[network.nodes()];
        int layer = 0;
        while (layer < this.layerAssignment.length) {
            Iterator iterator = this.layerAssignment[layer].iterator();
            while (iterator.hasNext()) {
                int nodeIndex = (Integer)iterator.next();
                px[nodeIndex] = (1.0 + (double)((Integer)this.layerAssignment[layer].get(nodeIndex)).intValue()) / (1.0 + (double)this.layerAssignment[layer].size());
                py[nodeIndex] = layer;
            }
            ++layer;
        }
        double minX = 1.0;
        double maxX = -1.0;
        double minY = 1.0;
        double maxY = -1.0;
        int i = 0;
        while (i < network.size()) {
            if (px[i] < minX) {
                minX = px[i];
            }
            if (px[i] > maxX) {
                maxX = px[i];
            }
            if (py[i] < minY) {
                minY = py[i];
            }
            if (py[i] > maxY) {
                maxY = py[i];
            }
            ++i;
        }
        double scaleX = maxX > minX ? 0.9 / (maxX - minX) : 1.0;
        double scaleY = maxY > minY ? 0.9 / (maxY - minY) : 1.0;
        int i2 = 0;
        while (i2 < network.size()) {
            x.set(i2, 0.05 + scaleX * (px[i2] - minX));
            y.set(i2, 0.05 + scaleY * (py[i2] - minY));
            ++i2;
        }
    }

    private Network greedyCycleRemoval(AttributeNetwork network) {
        DynamicList<Integer> sl = new DynamicList<Integer>();
        DynamicList<Integer> sr = new DynamicList<Integer>();
        DynamicSet<Integer> removedNodes = new DynamicSet<Integer>();
        while (removedNodes.size() < network.nodes()) {
            int sinkNodeIndex = this.findFirstByType(network, removedNodes, NodeType.SINK);
            while (sinkNodeIndex != -1) {
                sr.add(sinkNodeIndex);
                removedNodes.add(sinkNodeIndex);
                sinkNodeIndex = this.findFirstByType(network, removedNodes, NodeType.SINK);
            }
            int sourceNodeIndex = this.findFirstByType(network, removedNodes, NodeType.SOURCE);
            while (sourceNodeIndex != -1) {
                sl.add(sourceNodeIndex);
                removedNodes.add(sourceNodeIndex);
                sourceNodeIndex = this.findFirstByType(network, removedNodes, NodeType.SOURCE);
            }
            if (removedNodes.size() >= network.nodes()) continue;
            int w = this.findMaximalDifference(network, removedNodes);
            removedNodes.add(w);
            sl.add(w);
        }
        DynamicList<Integer> nodesOrder = new DynamicList<Integer>();
        int i = 0;
        while (i < sl.size()) {
            nodesOrder.add((Integer)sl.get(i));
            ++i;
        }
        i = sr.size() - 1;
        while (i >= 0) {
            nodesOrder.add((Integer)sr.get(i));
            --i;
        }
        AttributeNetwork acyclicNetwork = new AttributeNetwork(network);
        LinkFilter filter = new LinkFilter(acyclicNetwork);
        int sourceIndex = 0;
        while (sourceIndex < network.nodes()) {
            filter.removeLink(sourceIndex, sourceIndex);
            int[] targetIndices = network.outLinks(sourceIndex);
            if (targetIndices != null) {
                int[] nArray = targetIndices;
                int n = targetIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int targetIndex = nArray[n2];
                    if ((Integer)nodesOrder.get(sourceIndex) > (Integer)nodesOrder.get(targetIndex)) {
                        filter.removeLink(sourceIndex, targetIndex);
                        if (!acyclicNetwork.contains(targetIndex, sourceIndex)) {
                            acyclicNetwork.add(targetIndex, sourceIndex);
                        }
                    }
                    ++n2;
                }
            }
            ++sourceIndex;
        }
        acyclicNetwork = new FilteredNetwork(acyclicNetwork, filter);
        return acyclicNetwork;
    }

    private int findFirstByType(AttributeNetwork network, Set<Integer> removedNodes, NodeType nodeType) {
        int nodeIndex = 0;
        while (nodeIndex < network.nodes()) {
            if (!removedNodes.contains(nodeIndex) && (nodeType == NodeType.SINK && this.actualDegree(nodeIndex, network.outLinks(nodeIndex), removedNodes) == 0 || nodeType == NodeType.SOURCE && this.actualDegree(nodeIndex, network.inLinks(nodeIndex), removedNodes) == 0)) {
                return nodeIndex;
            }
            ++nodeIndex;
        }
        return -1;
    }

    private int findMaximalDifference(AttributeNetwork network, Set<Integer> removedNodes) {
        int index = -1;
        double maxValue = -1.7976931348623157E308;
        int nodeIndex = 0;
        while (nodeIndex < network.nodes()) {
            int currentValue;
            if (!removedNodes.contains(nodeIndex) && (double)(currentValue = this.actualDegree(nodeIndex, network.outLinks(nodeIndex), removedNodes) - this.actualDegree(nodeIndex, network.inLinks(nodeIndex), removedNodes)) > maxValue) {
                maxValue = currentValue;
                index = nodeIndex;
            }
            ++nodeIndex;
        }
        return index;
    }

    private int actualDegree(int nodeIndex, int[] links, Set<Integer> removedNodes) {
        int degree = 0;
        if (links != null) {
            int[] nArray = links;
            int n = links.length;
            int n2 = 0;
            while (n2 < n) {
                int node = nArray[n2];
                if (!removedNodes.contains(node)) {
                    ++degree;
                }
                ++n2;
            }
        }
        return degree;
    }

    private Dictionary<Integer, Integer>[] layerAssignmentByLongestPath(Network acyclicNetwork) {
        int[] nodeToLayer = new int[acyclicNetwork.nodes()];
        DynamicSet<Integer> U = new DynamicSet<Integer>();
        DynamicSet<Integer> Z = new DynamicSet<Integer>();
        int currentLayer = 0;
        while (U.size() < acyclicNetwork.nodes()) {
            int vertex = -1;
            boolean vertexSelected = false;
            int i = 0;
            while (i < acyclicNetwork.nodes() && !vertexSelected) {
                if (!U.contains(i)) {
                    vertexSelected = true;
                    int[] outNodes = acyclicNetwork.outLinks(i);
                    if (outNodes != null) {
                        int[] nArray = outNodes;
                        int n = outNodes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int out = nArray[n2];
                            if (!Z.contains(out)) {
                                vertexSelected = false;
                            }
                            ++n2;
                        }
                    }
                    if (vertexSelected) {
                        vertex = i;
                        vertexSelected = true;
                    }
                }
                ++i;
            }
            if (vertex != -1) {
                nodeToLayer[vertex] = currentLayer;
                U.add(vertex);
                continue;
            }
            ++currentLayer;
            Iterator iter = U.iterator();
            while (iter.hasNext()) {
                Z.add((Integer)iter.next());
            }
        }
        int numLayers = currentLayer + 1;
        Dictionary[] assignment = new Dictionary[numLayers];
        int layer = 0;
        while (layer < numLayers) {
            assignment[layer] = new DynamicDictionary();
            ++layer;
        }
        int[] nodesAssignedToLayer = new int[numLayers];
        int node = 0;
        while (node < nodeToLayer.length) {
            int layer2 = nodeToLayer[node];
            assignment[layer2].set(node, nodesAssignedToLayer[layer2]);
            int n = layer2;
            nodesAssignedToLayer[n] = nodesAssignedToLayer[n] + 1;
            ++node;
        }
        return assignment;
    }

    private void reduceCrossings(Network network) {
        Iterator iter2;
        int[][][] linksPerLayer = new int[this.layerAssignment.length - 1][][];
        int layer = 0;
        while (layer < this.layerAssignment.length - 1) {
            DynamicList<int[]> links = new DynamicList<int[]>();
            Iterator iter1 = this.layerAssignment[layer].iterator();
            while (iter1.hasNext()) {
                int u = (Integer)iter1.next();
                iter2 = this.layerAssignment[layer + 1].iterator();
                while (iter2.hasNext()) {
                    int w = (Integer)iter2.next();
                    if (!network.contains(u, w) && !network.contains(w, u)) continue;
                    links.add(new int[]{u, w});
                }
            }
            linksPerLayer[layer] = new int[links.size()][2];
            int linkIndex = 0;
            while (linkIndex < links.size()) {
                linksPerLayer[layer][linkIndex] = (int[])links.get(linkIndex);
                ++linkIndex;
            }
            ++layer;
        }
        layer = this.layerAssignment.length - 2;
        while (layer >= 0) {
            boolean restartLayer;
            int currentCrosses = this.countCrosses(network, layer, linksPerLayer);
            do {
                restartLayer = false;
                Iterator iter1 = this.layerAssignment[layer].iterator();
                iter2 = this.layerAssignment[layer].iterator();
                while (iter1.hasNext() && !restartLayer) {
                    int node1 = (Integer)iter1.next();
                    while (iter2.hasNext() && !restartLayer) {
                        int node2 = (Integer)iter2.next();
                        this.swapNodePositions(node1, node2, layer);
                        int nextCrosses = this.countCrosses(network, layer, linksPerLayer);
                        if (nextCrosses < currentCrosses) {
                            currentCrosses = nextCrosses;
                            restartLayer = true;
                            continue;
                        }
                        this.swapNodePositions(node1, node2, layer);
                    }
                }
            } while (restartLayer);
            --layer;
        }
    }

    private void swapNodePositions(int node1, int node2, int layer) {
        int temp = (Integer)this.layerAssignment[layer].get(node1);
        this.layerAssignment[layer].set(node1, (Integer)this.layerAssignment[layer].get(node2));
        this.layerAssignment[layer].set(node2, temp);
    }

    private int countCrosses(Network network, int layer, int[][][] linksPerLayer) {
        int crosses = 0;
        int i = 0;
        while (i < linksPerLayer[layer].length) {
            int j = i + 1;
            while (j < linksPerLayer[layer].length) {
                int[] linkJ;
                int[] linkI = new int[]{(Integer)this.layerAssignment[layer].get(linksPerLayer[layer][i][0]), (Integer)this.layerAssignment[layer + 1].get(linksPerLayer[layer][i][1])};
                if (linkI[0] > (linkJ = new int[]{(Integer)this.layerAssignment[layer].get(linksPerLayer[layer][j][0]), (Integer)this.layerAssignment[layer + 1].get(linksPerLayer[layer][j][1])})[0] && linkI[1] < linkJ[1] || linkI[0] < linkJ[0] && linkI[1] > linkJ[1]) {
                    ++crosses;
                }
                ++j;
            }
            ++i;
        }
        return crosses;
    }

    private static enum NodeType {
        SINK,
        SOURCE;

    }
}

