/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.visualization;

import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.NetworkLayout;

public class HypercubeLayout
extends NetworkLayout {
    @Override
    public void layout(AttributeNetwork network, Attribute<Double> x, Attribute<Double> y) {
        int nodes = network.size();
        int dimension = (int)Math.ceil(Math.log(nodes) / Math.log(2.0));
        double maxX = this.xcoord((1 << dimension) - 1, dimension);
        double maxY = this.ycoord((1 << dimension) - 1, dimension);
        int i = 0;
        while (i < nodes) {
            x.set(i, 0.05 + 0.9 * this.xcoord(i, dimension) / maxX);
            y.set(i, 0.05 + 0.9 * this.ycoord(i, dimension) / maxY);
            ++i;
        }
    }

    public double xcoord(int i, int d) {
        return this.alternativeBits(i, d) + (d % 2 == 1 ? 0 : this.msb(i, d));
    }

    public double ycoord(int i, int d) {
        return this.alternativeBits(i >> 1, d) + (d % 2 == 0 ? 0 : this.msb(i, d));
    }

    private int alternativeBits(int i, int d) {
        if (i == 0) {
            return 0;
        }
        return i % 2 * (1 << d / 2) + this.alternativeBits(i >> 2, d - 2);
    }

    private int msb(int i, int d) {
        return i >> d - 1;
    }
}

