/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.visualization;

import ikor.math.random.Random;
import noesis.LinkEvaluator;
import noesis.Network;
import noesis.algorithms.paths.AllPairsDijkstra;
import noesis.algorithms.visualization.IterativeNetworkLayout;

public class KamadaKawaiLayout
extends IterativeNetworkLayout {
    private static final int MAX_ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-4;
    private static final double K = 1.0;
    private static final int WAIT_ITERATIONS = 50;
    public static final double MIN_TEMPERATURE = 0.005;
    public static final double INITIAL_TEMPERATURE = 1.0;
    public static final double COOLING_FACTOR = 0.95;
    private static final double DISCONNECTED_RATIO = 0.75;
    private int iteration;
    private double displaySideLength;
    private double[][] distances;
    private double L;
    private double[][] l;
    private double[][] k;
    private double[] px;
    private double[] py;
    private boolean finished;
    private int waitedIterations;
    private double bestDelta;

    @Override
    public void init() {
        int targetNode;
        this.waitedIterations = 0;
        this.bestDelta = Double.POSITIVE_INFINITY;
        AllPairsDijkstra<Integer, Integer> dijkstra = new AllPairsDijkstra<Integer, Integer>(this.network, new ExistingLinkEvaluator(this.network));
        dijkstra.run();
        this.distances = dijkstra.distance();
        double diameter = 0.0;
        int i = 0;
        while (i < this.network.nodes()) {
            int j = i + 1;
            while (j < this.network.nodes()) {
                if (diameter < this.distances[i][j] && Double.isFinite(this.distances[i][j])) {
                    diameter = this.distances[i][j];
                }
                ++j;
            }
            ++i;
        }
        int sourceNode = 0;
        while (sourceNode < this.network.nodes()) {
            targetNode = 0;
            while (targetNode < this.network.nodes()) {
                if (this.distances[sourceNode][targetNode] == Double.POSITIVE_INFINITY) {
                    this.distances[sourceNode][targetNode] = diameter * 0.75;
                }
                ++targetNode;
            }
            ++sourceNode;
        }
        this.displaySideLength = 0.9;
        this.L = this.displaySideLength / diameter;
        this.l = new double[this.network.nodes()][this.network.nodes()];
        this.k = new double[this.network.nodes()][this.network.nodes()];
        sourceNode = 0;
        while (sourceNode < this.network.nodes()) {
            targetNode = 0;
            while (targetNode < this.network.nodes()) {
                if (sourceNode != targetNode) {
                    this.l[sourceNode][targetNode] = this.L * this.distances[sourceNode][targetNode];
                    this.k[sourceNode][targetNode] = 1.0 / (this.distances[sourceNode][targetNode] * this.distances[sourceNode][targetNode]);
                }
                ++targetNode;
            }
            ++sourceNode;
        }
        this.px = new double[this.network.size()];
        this.py = new double[this.network.size()];
        i = 0;
        while (i < this.network.size()) {
            this.px[i] = Random.random();
            this.py[i] = Random.random();
            ++i;
        }
        this.finished = false;
        this.iteration = 0;
    }

    @Override
    public boolean stop() {
        return this.finished || this.iteration >= 1000;
    }

    @Override
    public void iterate() {
        this.finished = true;
        double maxDelta = 0.0;
        double currentDelta = 0.0;
        int m = -1;
        int i = 0;
        while (i < this.network.nodes()) {
            double diffY;
            double diffX = this.diffX(i);
            currentDelta = this.delta(i, diffX, diffY = this.diffY(i));
            if (currentDelta > maxDelta) {
                maxDelta = currentDelta;
                m = i;
            }
            ++i;
        }
        if (this.waitedIterations < 50 && maxDelta > 1.0E-4 && this.iteration < 1000) {
            if (maxDelta < this.bestDelta) {
                this.waitedIterations = 0;
                this.bestDelta = maxDelta;
            } else {
                ++this.waitedIterations;
            }
            this.finished = false;
            int internalIterations = 0;
            double delta = 0.0;
            double diffXm = this.diffX(m);
            double diffYm = this.diffY(m);
            delta = this.delta(m, diffXm, diffYm);
            double localTemperature = 1.0;
            while (localTemperature > 0.005 && delta > 1.0E-4 && internalIterations < 1000) {
                double diffX2m = 0.0;
                double diffY2m = 0.0;
                double diffXYm = 0.0;
                int i2 = 0;
                while (i2 < this.network.nodes()) {
                    if (i2 != m) {
                        double dx = this.px[m] - this.px[i2];
                        double dy = this.py[m] - this.py[i2];
                        double dist = Math.sqrt(dx * dx + dy * dy);
                        double denominator = dist * dist * dist;
                        diffX2m += this.k[m][i2] * (1.0 - this.l[m][i2] * dy * dy / denominator);
                        diffY2m += this.k[m][i2] * (1.0 - this.l[m][i2] * dy * dy / denominator);
                        diffXYm += this.k[m][i2] * (this.l[m][i2] * dx * dy) / denominator;
                    }
                    ++i2;
                }
                double oDenominator = diffX2m * diffY2m - diffXYm * diffXYm;
                double ox = (-diffXm * diffY2m - diffXYm * -diffYm) / oDenominator;
                double oy = (diffX2m * -diffYm - -diffXm * diffXYm) / oDenominator;
                this.px[m] = this.px[m] + localTemperature * ox;
                this.py[m] = this.py[m] + localTemperature * oy;
                localTemperature = this.cool(localTemperature);
                diffXm = this.diffX(m);
                diffYm = this.diffY(m);
                delta = this.delta(m, diffXm, diffYm);
                ++internalIterations;
            }
        }
        ++this.iteration;
    }

    @Override
    public void end() {
        double minX = 1.0;
        double maxX = -1.0;
        double minY = 1.0;
        double maxY = -1.0;
        int i = 0;
        while (i < this.network.size()) {
            if (this.px[i] < minX) {
                minX = this.px[i];
            }
            if (this.px[i] > maxX) {
                maxX = this.px[i];
            }
            if (this.py[i] < minY) {
                minY = this.py[i];
            }
            if (this.py[i] > maxY) {
                maxY = this.py[i];
            }
            ++i;
        }
        double scaleX = maxX > minX ? 0.9 / (maxX - minX) : 1.0;
        double scaleY = maxY > minY ? 0.9 / (maxY - minY) : 1.0;
        int i2 = 0;
        while (i2 < this.network.size()) {
            this.x.set(i2, 0.05 + scaleX * (this.px[i2] - minX));
            this.y.set(i2, 0.05 + scaleY * (this.py[i2] - minY));
            ++i2;
        }
        this.distances = null;
        this.l = null;
        this.k = null;
        this.px = null;
        this.py = null;
    }

    private double diffX(int m) {
        double value = 0.0;
        int i = 0;
        while (i < this.network.nodes()) {
            if (i != m) {
                double dx = this.px[m] - this.px[i];
                double dy = this.py[m] - this.py[i];
                value += this.k[m][i] * (dx - this.l[m][i] * dx / Math.sqrt(dx * dx + dy * dy));
            }
            ++i;
        }
        return value;
    }

    private double diffY(int m) {
        double value = 0.0;
        int i = 0;
        while (i < this.network.nodes()) {
            if (i != m) {
                double dx = this.px[m] - this.px[i];
                double dy = this.py[m] - this.py[i];
                value += this.k[m][i] * (dy - this.l[m][i] * dy / Math.sqrt(dx * dx + dy * dy));
            }
            ++i;
        }
        return value;
    }

    private double delta(int m, double diffXm, double diffYm) {
        return Math.sqrt(diffXm * diffXm + diffYm * diffYm);
    }

    private double cool(double t) {
        return t * 0.95;
    }

    class ExistingLinkEvaluator
    implements LinkEvaluator {
        private Network net;

        public ExistingLinkEvaluator(Network net) {
            this.net = net;
        }

        @Override
        public double evaluate(int source, int destination) {
            return this.net.contains(source, destination) ? 1.0 : Double.POSITIVE_INFINITY;
        }
    }
}

