/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.visualization;

import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.algorithms.visualization.NetworkLayout;

public class MeshLayout
extends NetworkLayout {
    private int rows;
    private int columns;

    public MeshLayout() {
    }

    public MeshLayout(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
    }

    @Override
    public void layout(AttributeNetwork network, Attribute<Double> x, Attribute<Double> y) {
        int height;
        int width;
        int nodes = network.size();
        if (this.columns != 0) {
            width = this.columns;
            height = this.rows;
        } else {
            height = width = (int)Math.ceil(Math.sqrt(nodes));
        }
        int i = 0;
        while (i < nodes) {
            int row = i / width;
            int column = i % width;
            x.set(i, 0.05 + 0.9 * (double)column / (double)(width - 1));
            y.set(i, 0.05 + 0.9 * (double)row / (double)(height - 1));
            ++i;
        }
    }
}

