/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.visualization;

import ikor.collection.DynamicList;
import ikor.collection.DynamicSet;
import ikor.collection.List;
import ikor.collection.Set;
import java.util.Iterator;
import noesis.Attribute;
import noesis.AttributeNetwork;
import noesis.algorithms.LinkVisitor;
import noesis.algorithms.traversal.ConnectedComponents;
import noesis.algorithms.traversal.NetworkBFS;
import noesis.algorithms.visualization.NetworkLayout;
import noesis.algorithms.visualization.strategy.MinAveragePathLengthSelectionStrategy;
import noesis.algorithms.visualization.strategy.SelectionStrategy;

public class RadialLayout
extends NetworkLayout {
    private SelectionStrategy rootSelector;

    public RadialLayout() {
        this.rootSelector = new MinAveragePathLengthSelectionStrategy();
    }

    public RadialLayout(SelectionStrategy rootSelector) {
        this.rootSelector = rootSelector;
    }

    @Override
    public void layout(AttributeNetwork network, Attribute<Double> x, Attribute<Double> y) {
        if (network.size() == 0) {
            return;
        }
        AttributeNetwork augmentedNetwork = this.createAugmentedNetwork(network);
        List<Integer>[] componentList = this.connectedComponents(augmentedNetwork);
        int rootNode = this.computeGlobalRootNode(augmentedNetwork, componentList);
        Set[] children = new Set[augmentedNetwork.size()];
        int[] predecessor = new int[augmentedNetwork.size()];
        boolean[] visited = new boolean[augmentedNetwork.size()];
        int i = 0;
        while (i < predecessor.length) {
            predecessor[i] = -1;
            ++i;
        }
        NetworkBFS<Integer, Integer> BFS2 = new NetworkBFS<Integer, Integer>(augmentedNetwork);
        BFSLinkVisitor visitor = new BFSLinkVisitor(predecessor, children, rootNode, visited);
        BFS2.setLinkVisitor(visitor);
        BFS2.traverse(rootNode);
        List<List<Integer>> levels = this.getNodeLevels(rootNode, children);
        double[] weights = this.computeNodeWeights(levels, predecessor);
        NodeInfo[] nodeInfo = this.computePositionInfo(rootNode, weights, predecessor, children);
        double correctionFactor = 0.9;
        int node = 0;
        while (node < network.size()) {
            double angle = nodeInfo[node].initialAngle + (nodeInfo[node].finalAngle - nodeInfo[node].initialAngle) / 2.0;
            double amplitude = correctionFactor * (0.5 * (double)nodeInfo[node].level / Math.max((double)(levels.size() - 1), 1.0));
            x.set(node, 0.5 + amplitude * Math.cos(angle * 2.0 * Math.PI));
            y.set(node, 0.5 + amplitude * Math.sin(angle * 2.0 * Math.PI));
            ++node;
        }
    }

    private int computeGlobalRootNode(AttributeNetwork undirectedNetwork, List<Integer>[] componentList) {
        int[] rootNodes = new int[componentList.length];
        int component = 0;
        while (component < componentList.length) {
            rootNodes[component] = this.rootSelector.select(undirectedNetwork, componentList[component]);
            ++component;
        }
        int rootNode = rootNodes[0];
        if (componentList.length > 1) {
            int[] nArray = rootNodes;
            int n = rootNodes.length;
            int n2 = 0;
            while (n2 < n) {
                int root = nArray[n2];
                undirectedNetwork.add2(undirectedNetwork.size() - 1, root);
                ++n2;
            }
            rootNode = undirectedNetwork.size() - 1;
        }
        return rootNode;
    }

    private NodeInfo[] computePositionInfo(int rootNode, double[] weight, int[] predecessor, Set<Integer>[] children) {
        NodeInfo[] nodeInfo = new NodeInfo[predecessor.length];
        int currentLevel = 0;
        DynamicSet<Integer> nodesCurrentLevel = new DynamicSet<Integer>();
        nodesCurrentLevel.add(rootNode);
        while (nodesCurrentLevel.size() > 0) {
            DynamicSet<Integer> nextLevelNodes = new DynamicSet<Integer>();
            Iterator iterator = nodesCurrentLevel.iterator();
            while (iterator.hasNext()) {
                int node = (Integer)iterator.next();
                double currentAngle = 0.0;
                double finalAngle = 1.0;
                if (predecessor[node] != -1) {
                    currentAngle = nodeInfo[predecessor[node]].childrenAngle;
                    double weightRatio = (weight[node] + 1.0) / weight[predecessor[node]];
                    double predecessorAngle = nodeInfo[predecessor[node]].finalAngle - nodeInfo[predecessor[node]].initialAngle;
                    nodeInfo[predecessor[node]].childrenAngle = finalAngle = currentAngle + predecessorAngle * weightRatio;
                }
                nodeInfo[node] = new NodeInfo(currentLevel, currentAngle, finalAngle, currentAngle);
                if (children[node] != null) {
                    Iterator iterator2 = children[node].iterator();
                    while (iterator2.hasNext()) {
                        int child = (Integer)iterator2.next();
                        nextLevelNodes.add(child);
                    }
                }
                nodesCurrentLevel = nextLevelNodes;
            }
            ++currentLevel;
        }
        return nodeInfo;
    }

    private List<List<Integer>> getNodeLevels(int rootNode, Set<Integer>[] children) {
        DynamicList<List<Integer>> nodesPerLevel = new DynamicList<List<Integer>>();
        DynamicList<Integer> currentNodes = new DynamicList<Integer>();
        currentNodes.add(rootNode);
        while (currentNodes.size() > 0) {
            nodesPerLevel.add(currentNodes);
            DynamicList<Integer> nextNodes = new DynamicList<Integer>();
            Iterator iterator = currentNodes.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (children[n] == null) continue;
                Iterator iterator2 = children[n].iterator();
                while (iterator2.hasNext()) {
                    int c = (Integer)iterator2.next();
                    nextNodes.add(c);
                }
            }
            currentNodes = nextNodes;
        }
        return nodesPerLevel;
    }

    private double[] computeNodeWeights(List<List<Integer>> levels, int[] predecessor) {
        double[] weights = new double[predecessor.length];
        int level = levels.size() - 1;
        while (level >= 1) {
            Iterator iterator = ((List)levels.get(level)).iterator();
            while (iterator.hasNext()) {
                int node = (Integer)iterator.next();
                weights[predecessor[node]] = weights[predecessor[node]] + weights[node] + 1.0;
            }
            --level;
        }
        return weights;
    }

    private AttributeNetwork createAugmentedNetwork(AttributeNetwork network) {
        AttributeNetwork undirectedNetwork = new AttributeNetwork();
        undirectedNetwork.setSize(network.size() + 1);
        int node = 0;
        while (node < network.size()) {
            int link = 0;
            while (link < network.outDegree(node)) {
                int target = network.outLink(node, link);
                if (!undirectedNetwork.contains(node, target)) {
                    undirectedNetwork.add2(node, target);
                }
                ++link;
            }
            ++node;
        }
        return undirectedNetwork;
    }

    private List<Integer>[] connectedComponents(AttributeNetwork network) {
        ConnectedComponents components = new ConnectedComponents(network);
        components.compute();
        List[] componentList = new List[components.components() - 1];
        int component = 0;
        while (component < componentList.length) {
            componentList[component] = new DynamicList();
            ++component;
        }
        int node = 0;
        while (node < network.nodes() - 1) {
            componentList[components.component(node) - 1].add(node);
            ++node;
        }
        return componentList;
    }

    class BFSLinkVisitor
    extends LinkVisitor {
        private Set<Integer>[] children;
        private int[] predecessor;
        private boolean[] visited;

        public BFSLinkVisitor(int[] predecessor, Set<Integer>[] children, int rootNode, boolean[] visited) {
            this.predecessor = predecessor;
            this.children = children;
            this.visited = visited;
            visited[rootNode] = true;
        }

        @Override
        public void visit(int source, int destination) {
            if (!this.visited[destination]) {
                this.visited[destination] = true;
                this.predecessor[destination] = source;
                if (this.children[source] == null) {
                    this.children[source] = new DynamicSet<Integer>();
                }
                this.children[source].add(destination);
            }
        }
    }

    private class NodeInfo {
        int level;
        double initialAngle;
        double finalAngle;
        double childrenAngle;

        public NodeInfo(int level, double initialAngle, double finalAngle, double childrenAngle) {
            this.level = level;
            this.initialAngle = initialAngle;
            this.finalAngle = finalAngle;
            this.childrenAngle = childrenAngle;
        }
    }
}

