/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.visualization.strategy;

import ikor.collection.List;
import java.util.Iterator;
import noesis.Network;
import noesis.algorithms.visualization.strategy.SelectionStrategy;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.Eccentricity;

public class MinEccentricitySelectionStrategy
implements SelectionStrategy {
    @Override
    public int select(Network network, List<Integer> candidateNodes) {
        NodeScore eccentricity = (NodeScore)new Eccentricity(network).getResult();
        int minIndex = -1;
        double minValue = Double.MAX_VALUE;
        Iterator iterator = candidateNodes.iterator();
        while (iterator.hasNext()) {
            int node = (Integer)iterator.next();
            if (!(eccentricity.get(node) < minValue)) continue;
            minValue = eccentricity.get(node);
            minIndex = node;
        }
        return minIndex;
    }
}

