/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis;

import noesis.Network;
import noesis.analysis.LinkScoreTask;
import noesis.analysis.Score;
import noesis.network.LinkIndex;
import noesis.network.LinkIndexer;

public class LinkScore
extends Score {
    private Network network;
    private LinkIndexer index;

    public LinkScore(LinkScoreTask creator, Network network, LinkIndexer index) {
        super(network.links());
        this.network = network;
        this.index = index;
        this.setName(creator.getName());
        this.setDescription(creator.getDescription());
    }

    public LinkScore(LinkScoreTask creator, Network network) {
        this(creator, network, new LinkIndex(network));
    }

    public final Network getNetwork() {
        return this.network;
    }

    public final LinkIndexer getIndex() {
        return this.index;
    }

    @Override
    public double get(int source, int destination) {
        int link = this.index.index(source, destination);
        if (link != -1) {
            return this.get(link);
        }
        return Double.NaN;
    }

    @Override
    public void set(int source, int destination, double value) {
        int link = this.index.index(source, destination);
        if (link != -1) {
            this.set(link, value);
        }
    }
}

