/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis;

import noesis.Network;
import noesis.NoesisTask;
import noesis.analysis.LinkScore;
import noesis.network.LinkIndex;
import noesis.network.LinkIndexer;

public abstract class LinkScoreTask
extends NoesisTask<LinkScore> {
    private Network network;
    private LinkIndexer index;

    public LinkScoreTask(Network network, LinkIndexer index) {
        this.network = network;
        this.index = index;
    }

    public LinkScoreTask(Network network) {
        this(network, new LinkIndex(network));
    }

    public final Network getNetwork() {
        return this.network;
    }

    public final LinkIndexer getLinkIndex() {
        return this.index;
    }

    public void checkDone() {
        if (this.getResult() == null) {
            this.compute();
        }
    }

    @Override
    public void compute() {
        int size = this.network.size();
        int pos = 0;
        LinkScore result = new LinkScore(this, this.network, this.index);
        int node = 0;
        while (node < size) {
            int link = 0;
            while (link < this.network.outDegree(node)) {
                result.set(pos, this.compute(node, this.network.outLink(node, link)));
                ++pos;
                ++link;
            }
            ++node;
        }
        this.setResult(result);
    }

    public abstract double compute(int var1, int var2);
}

