/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis;

import ikor.collection.CollectionFactory;
import ikor.collection.List;
import ikor.model.data.DataModel;
import ikor.parallel.Task;
import noesis.Network;
import noesis.analysis.NodeScore;

public abstract class NodeScoreGroupTask
extends Task<List<NodeScore>> {
    private Network network;
    protected List<NodeScore> measures = null;

    public NodeScoreGroupTask(Network network) {
        this.network = network;
    }

    public final Network getNetwork() {
        return this.network;
    }

    protected final List<NodeScore> createMeasures(Network network) {
        String[] names = this.getNames();
        String[] descriptions = this.getDescriptions();
        DataModel[] models = this.getModels();
        List measures = CollectionFactory.createList();
        int i = 0;
        while (i < names.length) {
            NodeScore measure = new NodeScore(names[i], network);
            measure.setMetadata(this);
            measure.setName(names[i]);
            measure.setDescription(descriptions[i]);
            measure.setModel(models[i]);
            measures.add(measure);
            ++i;
        }
        return measures;
    }

    protected abstract String[] getNames();

    protected abstract String[] getDescriptions();

    protected abstract DataModel[] getModels();

    @Override
    public List<NodeScore> call() {
        this.compute();
        return this.measures;
    }

    public void checkDone() {
        if (this.measures == null) {
            this.compute();
        }
    }

    public abstract void compute();

    public abstract double[] compute(int var1);
}

