/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis;

import ikor.model.data.DataModel;
import noesis.Network;
import noesis.NoesisTask;
import noesis.analysis.NodeScore;

public abstract class NodeScoreTask
extends NoesisTask<NodeScore> {
    private DataModel model;
    private Network network;

    public NodeScoreTask(DataModel model, Network network) {
        this.model = model;
        this.network = network;
    }

    public NodeScoreTask(Network network) {
        this(NodeScore.REAL_MODEL, network);
    }

    public final DataModel getModel() {
        return this.model;
    }

    public final Network getNetwork() {
        return this.network;
    }

    public final double getResult(int node) {
        return ((NodeScore)this.getResult()).get(node);
    }

    public final void setResult(int node, double value) {
        ((NodeScore)this.getResult()).set(node, value);
    }

    @Override
    public final void setResult(double[] values) {
        NodeScore score = new NodeScore(this, this.getNetwork());
        score.set(values);
        this.setResult(score);
    }

    public void checkDone() {
        if (this.getResult() == null) {
            this.compute();
        }
    }

    @Override
    public void compute() {
        int size = this.network.size();
        NodeScore score = new NodeScore(this, this.network);
        int node = 0;
        while (node < size) {
            score.set(node, this.compute(node));
            ++node;
        }
        this.setResult(score);
    }

    public abstract double compute(int var1);
}

