/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.algorithms.traversal.StronglyConnectedComponents;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.Betweenness;

@Label(value="adj-betweenness")
@Description(value="Adjusted betweenness")
public class AdjustedBetweenness
extends Betweenness {
    public AdjustedBetweenness(Network network) {
        super(network);
    }

    @Override
    public String getName() {
        return "betweenness";
    }

    @Override
    public String getDescription() {
        return "Betweenness";
    }

    @Override
    public void compute() {
        super.compute();
        NodeScore score = (NodeScore)this.getResult();
        StronglyConnectedComponents scc = new StronglyConnectedComponents(this.getNetwork());
        scc.compute();
        int node = 0;
        while (node < this.getNetwork().size()) {
            int size = scc.componentSize(node);
            score.set(node, score.get(node) - (double)(2 * size - 1));
            ++node;
        }
        this.setResult(score);
    }
}

