/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;
import noesis.analysis.structure.PathLength;

@Label(value="avg-path-length")
@Description(value="Average path length")
public class AveragePathLength
extends NodeScoreTask {
    private int diameter = 0;

    public AveragePathLength(Network network) {
        super(network);
    }

    @Override
    public double compute(int node) {
        PathLength paths = new PathLength(this.getNetwork(), node);
        paths.compute();
        int radius = (int)((NodeScore)paths.getResult()).max();
        if (radius > this.diameter) {
            this.diameter = radius;
        }
        return paths.averagePathLength();
    }

    public double averagePathLength() {
        this.checkDone();
        return ((NodeScore)this.getResult()).average();
    }

    public int diameter() {
        this.checkDone();
        return this.diameter;
    }
}

