/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.math.Vector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import ikor.parallel.Kernel;
import ikor.parallel.Parallel;
import ikor.parallel.combiner.VectorAccumulator;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;
import noesis.analysis.structure.BetweennessScore;

@Label(value="betweenness")
@Description(value="Node betweenness")
public class Betweenness
extends NodeScoreTask {
    public Betweenness(Network network) {
        super(network);
    }

    @Override
    public double compute(int node) {
        this.checkDone();
        return this.getResult(node);
    }

    @Override
    public void compute() {
        Network net = this.getNetwork();
        int size = net.size();
        NodeScore measure = new NodeScore(this, net);
        Vector score = (Vector)Parallel.reduce(new BetweennessKernel(net), new VectorAccumulator(size), 0, size - 1);
        int i = 0;
        while (i < size) {
            measure.set(i, score.get(i));
            ++i;
        }
        this.setResult(measure);
    }

    class BetweennessKernel
    implements Kernel<Vector> {
        private Network net;

        public BetweennessKernel(Network net) {
            this.net = net;
        }

        @Override
        public Vector call(int index) {
            BetweennessScore score = new BetweennessScore(this.net, index);
            return (Vector)score.call();
        }
    }
}

