/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.algorithms.LinkVisitor;
import noesis.algorithms.traversal.NetworkBFS;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;

@Label(value="betweenness-score")
@Description(value="Betweenness score")
public class BetweennessScore
extends NodeScoreTask {
    private int[] distance;
    private int[] geodesics;
    private int[] visits;
    private int node;
    private int visited;
    private NodeScore score;

    public BetweennessScore(Network network, int node) {
        super(network);
        this.distance = new int[network.size()];
        this.geodesics = new int[network.size()];
        this.visits = new int[network.size()];
        this.node = node;
    }

    public int node() {
        return this.node;
    }

    public int distance(int node) {
        return this.distance[node];
    }

    public int geodesics(int node) {
        return this.geodesics[node];
    }

    public int visit(int pos) {
        return this.visits[pos];
    }

    public int visited() {
        return this.visited;
    }

    public double betweenness(int node) {
        if (this.getResult() != null) {
            return ((NodeScore)this.getResult()).get(node);
        }
        return 0.0;
    }

    @Override
    public void compute() {
        Network net = this.getNetwork();
        NetworkBFS bfs = new NetworkBFS(net);
        this.score = new NodeScore(this, net);
        this.geodesics[this.node] = 1;
        this.visits[0] = this.node;
        this.visited = 1;
        bfs.setLinkVisitor(new GeodesicVisitor(this));
        bfs.traverse(this.node);
        int i = this.visited - 1;
        while (i >= 0) {
            this.score.set(this.visits[i], this.nodeScore(this.visits[i]));
            --i;
        }
        this.setResult(this.score);
    }

    @Override
    public double compute(int node) {
        this.checkDone();
        return this.getResult(node);
    }

    private double nodeScore(int node) {
        Network network = this.getNetwork();
        int degree = network.outDegree(node);
        int[] links = network.outLinks(node);
        double distance = this.distance(node);
        double geodesics = this.geodesics(node);
        double result = 1.0;
        if (links != null) {
            int j = 0;
            while (j < degree) {
                if ((double)this.distance(links[j]) == distance + 1.0) {
                    result += this.score.get(links[j]) * geodesics / (double)this.geodesics(links[j]);
                }
                ++j;
            }
        }
        return result;
    }

    private class GeodesicVisitor
    extends LinkVisitor {
        private BetweennessScore data;

        public GeodesicVisitor(BetweennessScore data) {
            this.data = data;
        }

        @Override
        public void visit(int source, int destination) {
            int d = this.data.distance[source];
            if (destination != this.data.node) {
                if (this.data.distance[destination] == 0) {
                    ((BetweennessScore)this.data).visits[((BetweennessScore)this.data).visited] = destination;
                    BetweennessScore betweennessScore = this.data;
                    betweennessScore.visited = betweennessScore.visited + 1;
                    ((BetweennessScore)this.data).distance[destination] = d + 1;
                    ((BetweennessScore)this.data).geodesics[destination] = this.data.geodesics[source];
                } else if (this.data.distance[destination] == d + 1) {
                    int[] nArray = this.data.geodesics;
                    int n = destination;
                    nArray[n] = nArray[n] + this.data.geodesics[source];
                }
            }
        }
    }
}

