/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;

@Label(value="cc")
@Description(value="Clustering coefficient")
public class ClusteringCoefficient
extends NodeScoreTask {
    public ClusteringCoefficient(Network network) {
        super(network);
    }

    @Override
    public double compute(int node) {
        Network net = this.getNetwork();
        int triangles = 0;
        int degree = net.outDegree(node);
        int[] links = net.outLinks(node);
        if (links != null) {
            int i = 0;
            while (i < degree) {
                int j = 0;
                while (j < degree) {
                    if (net.contains(links[i], links[j])) {
                        ++triangles;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (degree > 1) {
            return (double)triangles / (double)(degree * (degree - 1));
        }
        return 0.0;
    }

    public double averageClusteringCoefficient() {
        this.checkDone();
        return ((NodeScore)this.getResult()).average();
    }
}

