/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.DataModel;
import noesis.Network;
import noesis.algorithms.traversal.StronglyConnectedComponents;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreGroupTask;
import noesis.analysis.structure.PathLength;

public class ConnectedComponents
extends NodeScoreGroupTask {
    public static final int COMPONENT = 0;
    public static final int COMPONENT_SIZE = 1;
    public static final int REACHABLE_NODES = 2;
    private static final String[] names = new String[]{"component", "scc-size", "reaches"};
    private static final String[] descriptions = new String[]{"Strongly connected component", "Connected component size", "Reachable nodes"};
    private static final DataModel[] models = new DataModel[]{NodeScore.INTEGER_MODEL, NodeScore.INTEGER_MODEL, NodeScore.INTEGER_MODEL};

    public ConnectedComponents(Network network) {
        super(network);
    }

    @Override
    public String[] getNames() {
        return names;
    }

    @Override
    public String[] getDescriptions() {
        return descriptions;
    }

    @Override
    public DataModel[] getModels() {
        return models;
    }

    @Override
    public void compute() {
        Network net = this.getNetwork();
        int size = net.size();
        this.measures = this.createMeasures(net);
        StronglyConnectedComponents scc = new StronglyConnectedComponents(net);
        scc.compute();
        int node = 0;
        while (node < size) {
            ((NodeScore)this.measures.get(0)).set(node, scc.component(node));
            ((NodeScore)this.measures.get(1)).set(node, scc.componentSize(node));
            PathLength paths = new PathLength(net, node);
            paths.compute();
            ((NodeScore)this.measures.get(2)).set(node, paths.reachableNodes());
            ++node;
        }
    }

    @Override
    public double[] compute(int node) {
        this.checkDone();
        return new double[]{((NodeScore)this.measures.get(0)).get(node), ((NodeScore)this.measures.get(1)).get(node), ((NodeScore)this.measures.get(2)).get(node)};
    }
}

