/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import noesis.Network;
import noesis.Parameter;
import noesis.analysis.NodeScoreTask;
import noesis.analysis.structure.PathLength;

@Description(value="Node decay")
public class Decay
extends NodeScoreTask {
    public static final double DEFAULT_DECAY = 0.5;
    @Parameter(min=0.0, max=1.0, defaultValue=0.5)
    private double delta;

    public Decay(Network network) {
        this(network, 0.5);
    }

    public Decay(Network network, double delta) {
        super(network);
        this.delta = delta;
    }

    public double getDelta() {
        return this.delta;
    }

    @Override
    public String getName() {
        return "decay-" + Math.round(100.0 * this.delta);
    }

    @Override
    public double compute(int node) {
        Network network = this.getNetwork();
        PathLength paths = new PathLength(network, node);
        paths.compute();
        return paths.decay(this.delta);
    }
}

