/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;

@Label(value="degree")
@Description(value="Node degree")
public class Degree
extends NodeScoreTask {
    public Degree(Network network) {
        super(NodeScore.INTEGER_MODEL, network);
    }

    @Override
    public double compute(int node) {
        Network net = this.getNetwork();
        return net.inDegree(node) + net.outDegree(node);
    }

    public double averageDegree() {
        Network net = this.getNetwork();
        return (double)net.links() / (double)net.nodes();
    }

    public double heterogeinity() {
        this.checkDone();
        double s = 0.0;
        double s2 = 0.0;
        NodeScore degree = (NodeScore)this.getResult();
        int nodes = degree.size();
        int i = 0;
        while (i < nodes) {
            double d = degree.get(i) / 2.0;
            s += d;
            s2 += d * d;
            ++i;
        }
        return s2 / (s * s) * (double)nodes;
    }
}

