/*
 * Decompiled with CFR 0.152.
 */
package noesis.analysis.structure;

import ikor.math.Vector;
import ikor.math.statistics.DiscreteProbabilityDistribution;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;
import noesis.analysis.structure.OutDegree;

@Label(value="degree-assortativity")
@Description(value="Degree assortativity")
public class DegreeAssortativity
extends NodeScoreTask {
    private DiscreteProbabilityDistribution distribution;
    protected double mean;
    protected double variance;

    public DegreeAssortativity(Network network) {
        super(network);
    }

    @Override
    public void compute() {
        Network network = this.getNetwork();
        int size = network.size();
        Vector degree = (Vector)new OutDegree(network).call();
        int maxDegree = (int)degree.max();
        double degreeAverage = degree.average();
        double[] degreeFraction = new double[maxDegree + 1];
        int node = 0;
        while (node < size) {
            int n = network.outDegree(node);
            degreeFraction[n] = degreeFraction[n] + 1.0;
            ++node;
        }
        int i = 0;
        while (i < degreeFraction.length) {
            int n = i++;
            degreeFraction[n] = degreeFraction[n] / (double)network.nodes();
        }
        double[] degreeValues = new double[maxDegree];
        double[] degreeProbabilities = new double[maxDegree];
        int i2 = 0;
        while (i2 < maxDegree) {
            degreeValues[i2] = i2;
            degreeProbabilities[i2] = (double)(i2 + 1) * degreeFraction[i2 + 1] / degreeAverage;
            ++i2;
        }
        this.distribution = new DiscreteProbabilityDistribution(degreeValues, degreeProbabilities);
        this.mean = this.distribution.mean();
        this.variance = this.distribution.variance();
        NodeScore score = new NodeScore(this, network);
        int node2 = 0;
        while (node2 < size) {
            score.set(node2, this.computeAssortativity(network, node2));
            ++node2;
        }
        this.setResult(score);
    }

    @Override
    public double compute(int node) {
        this.checkDone();
        return this.getResult(node);
    }

    private double computeAssortativity(Network network, int node) {
        double nodeExcessDegree = network.outDegree(node) - 1;
        double avgNeighboursExcessDegree = 0.0;
        int neighbors = network.outDegree(node);
        int i = 0;
        while (i < neighbors) {
            avgNeighboursExcessDegree += (double)(network.outDegree(network.outLink(node, i)) - 1);
            ++i;
        }
        if (neighbors > 0) {
            avgNeighboursExcessDegree /= (double)neighbors;
        }
        if (this.variance == 0.0) {
            return 1.0 / (double)network.size();
        }
        return this.assortativity(network, nodeExcessDegree, avgNeighboursExcessDegree);
    }

    protected double assortativity(Network network, double nodeExcessDegree, double avgNeighboursExcessDegree) {
        return (nodeExcessDegree + 1.0) * (nodeExcessDegree * avgNeighboursExcessDegree - this.mean * this.mean) / ((double)network.links() * this.variance);
    }

    public double networkAssortativity() {
        this.checkDone();
        return ((NodeScore)this.getResult()).sum();
    }
}

